/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.DbzElementEnumerator;
import Acme.DbzKeyEnumerator;
import Acme.DbzSearcher;
import Acme.Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Enumeration;

public class Dbz
extends Dictionary {
    private static final int dbzVersion = 3;
    private static final int SOF = 4;
    private static final int VACANT = 0;
    private int tagbits;
    private int taghere;
    private int tagboth;
    private static final int DEFSIZE = 120011;
    private static final char DEFCASE = 'C';
    private static final int TAGENB = 128;
    private static final int TAGMASK = 127;
    private static final int TAGSHIFT = 24;
    boolean olddbz;
    int tsize;
    int[] used = new int[11];
    int valuesize;
    int[] bytemap = new int[4];
    char casemap;
    char fieldsep;
    int tagenb;
    int tagmask;
    int tagshift;
    private boolean incore = true;
    private int[] pagbuf = new int[16];
    private byte[] basebuf = new byte[64];
    private static final int NOTFOUND = -1;
    DbzSearcher srch = new DbzSearcher();
    DbzSearcher prev;
    private int[] mybmap = new int[4];
    private boolean bytesame;
    private RandomAccessFile basef;
    private RandomAccessFile dirf;
    private RandomAccessFile pagf;
    private boolean readOnly;
    private int pagpos;
    private int[] corepag;
    private boolean written;
    private static final int[] smallPrimes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37};
    private static final int POLY = 0x48000000;
    private int[] crctable = new int[128];

    private static int BIAS(int o) {
        return o + 1;
    }

    private static int UNBIAS(int o) {
        return o - 1;
    }

    private boolean HASTAG(int o) {
        return (o & this.taghere) != 0;
    }

    private int TAG(int o) {
        return o & this.tagbits;
    }

    private int NOTAG(int o) {
        return o & ~this.tagboth;
    }

    private boolean CANTAG(int o) {
        return (o & this.tagboth) == 0;
    }

    private int MKTAG(int v) {
        return v << this.tagshift & this.tagbits;
    }

    private int MAPIN(int o) {
        if (this.bytesame) {
            return o;
        }
        return this.bytemap(o, this.bytemap, this.mybmap);
    }

    private int MAPOUT(int o) {
        if (this.bytesame) {
            return o;
        }
        return this.bytemap(o, this.mybmap, this.bytemap);
    }

    public Dbz(File file) throws IOException {
        try {
            this.basef = new RandomAccessFile(file, "rw");
            this.dirf = new RandomAccessFile(String.valueOf(file.getPath()) + ".dir", "rw");
            this.pagf = new RandomAccessFile(String.valueOf(file.getPath()) + ".pag", "rw");
            this.readOnly = false;
        }
        catch (Exception exception) {
            this.basef = new RandomAccessFile(file, "r");
            this.dirf = new RandomAccessFile(String.valueOf(file.getPath()) + ".dir", "r");
            this.pagf = new RandomAccessFile(String.valueOf(file.getPath()) + ".pag", "r");
            this.readOnly = true;
        }
        this.pagpos = -1;
        this.getconf();
        this.tagbits = this.tagmask << this.tagshift;
        this.taghere = this.tagenb << this.tagshift;
        this.tagboth = this.tagbits | this.taghere;
        this.mybytemap(this.mybmap);
        this.bytesame = true;
        int i = 0;
        while (i < 4) {
            if (this.mybmap[i] != this.bytemap[i]) {
                this.bytesame = false;
            }
            ++i;
        }
        int s = this.tsize * 4;
        this.corepag = (int[])(this.incore && s / 4 == this.tsize ? this.getcore() : null);
        this.crcinit();
        this.written = false;
        this.prev = null;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public Enumeration keys() {
        return new DbzKeyEnumerator();
    }

    public Enumeration elements() {
        return new DbzElementEnumerator(this);
    }

    public Object get(Object key) {
        return this.fetch(this.mapcase((String)key));
    }

    public Object put(Object key, Object value) {
        return this.store(this.mapcase((String)key), value);
    }

    public Object remove(Object key) {
        return null;
    }

    public static void main(String[] args) {
    }

    public int dbzsize(int contents) {
        if (contents <= 0) {
            return 120011;
        }
        int n = contents / 2 * 3;
        if (Utils.even(n)) {
            ++n;
        }
        while (!this.isprime(n)) {
            n += 2;
        }
        return n;
    }

    private boolean isprime(int x) {
        int div = 0;
        int i = 0;
        while (i < smallPrimes.length) {
            div = smallPrimes[i];
            if (x % div == 0) {
                return false;
            }
            ++i;
        }
        int stop = x;
        while (x / stop < stop) {
            stop >>= 1;
        }
        stop <<= 1;
        div += 2;
        while (div < stop) {
            if (x % div == 0) {
                return false;
            }
            div += 2;
        }
        return true;
    }

    public void dbmclose() {
        this.dbzsync();
        try {
            this.basef.close();
            this.dirf.close();
            this.pagf.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void dbzsync() {
        if (!this.written) {
            return;
        }
        if (this.corepag != null) {
            this.putcore(this.corepag);
        }
        if (!this.olddbz) {
            this.putconf();
        }
    }

    public void dbzcancel() {
        this.written = false;
    }

    public Object fetch(Object key) {
        Object output = null;
        this.prev = null;
        String skey = (String)key;
        skey.length();
        return output;
    }

    public Object store(Object key, Object value) {
        if (this.readOnly) {
            throw new RuntimeException("database is read-only");
        }
        return null;
    }

    public void dbzincore(boolean value) {
        this.incore = value;
    }

    private void getconf() {
    }

    private void putconf() {
    }

    private int[] getcore() {
        return null;
    }

    private void putcore(int[] tab) {
    }

    private void start() {
    }

    private int search() {
        return -1;
    }

    private boolean okayvalue(int value) {
        return !this.HASTAG(value);
    }

    private void set(DbzSearcher s, int value) {
    }

    private void mybytemap(int[] map) {
    }

    private int bytemap(int ino, int[] map1, int[] map2) {
        return ino;
    }

    private void crcinit() {
        int i = 0;
        while (i < this.crctable.length) {
            int sum = 0;
            int j = 6;
            while (j >= 0) {
                if ((i & 1 << j) != 0) {
                    sum ^= 0x48000000 >> j;
                }
                --j;
            }
            this.crctable[i] = sum;
            ++i;
        }
    }

    private int hash(String name) {
        int sum = 0;
        int i = 0;
        while (i < name.length()) {
            char b = name.charAt(i);
            int j = (sum ^ b) & 0x7F;
            sum = sum >> 7 ^ this.crctable[j];
            ++i;
        }
        return sum;
    }

    private String mapcase(String src) {
        return src;
    }
}

