/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.FlexVectorEnumerator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class FlexVector
implements Cloneable {
    protected Object[] elementData;
    protected int elementCount;
    protected int elementOffset;
    protected int capacityIncrement;

    public FlexVector(int initialCapacity, int capacityIncrement) {
        this.elementData = new Object[initialCapacity];
        this.elementCount = 0;
        this.elementOffset = 0;
        this.capacityIncrement = capacityIncrement;
    }

    public FlexVector(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public FlexVector() {
        this(10);
    }

    public final synchronized void copyInto(Object[] anArray) {
        int i = 0;
        while (i < this.elementCount) {
            anArray[i] = this.elementData[this.elementOffset + i];
            ++i;
        }
    }

    public final synchronized void trimToSize() {
        int oldCapacity = this.elementData.length;
        if (this.elementCount < oldCapacity) {
            Object[] oldData = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(oldData, this.elementOffset, this.elementData, 0, this.elementCount);
            this.elementOffset = 0;
        }
    }

    public final synchronized void ensureCapacity(int minCapacity) {
        int oldTotalCapacity = this.elementData.length;
        int oldUsableCapacity = oldTotalCapacity - this.elementOffset;
        if (oldUsableCapacity < minCapacity) {
            if (oldTotalCapacity >= minCapacity) {
                System.arraycopy(this.elementData, this.elementOffset, this.elementData, 0, this.elementCount);
                int i = this.elementCount;
                while (i < this.elementCount + this.elementOffset) {
                    this.elementData[i] = null;
                    ++i;
                }
            } else {
                int newCapacity;
                Object[] oldData = this.elementData;
                int n = newCapacity = this.capacityIncrement > 0 ? oldTotalCapacity + this.capacityIncrement : oldTotalCapacity * 2;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.elementData = new Object[newCapacity];
                System.arraycopy(oldData, this.elementOffset, this.elementData, 0, this.elementCount);
            }
            this.elementOffset = 0;
        }
    }

    public final synchronized void setSize(int newSize) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
        } else {
            int i = newSize;
            while (i < this.elementCount) {
                this.elementData[this.elementOffset + i] = null;
                ++i;
            }
        }
        this.elementCount = newSize;
        if (this.elementCount == 0) {
            this.elementOffset = 0;
        }
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public final int size() {
        return this.elementCount;
    }

    public final boolean isEmpty() {
        return this.elementCount == 0;
    }

    public final synchronized Enumeration elements() {
        return new FlexVectorEnumerator(this);
    }

    public final boolean contains(Object elem) {
        return this.indexOf(elem, 0) >= 0;
    }

    public final int indexOf(Object elem) {
        return this.indexOf(elem, 0);
    }

    public final synchronized int indexOf(Object elem, int index) {
        int i = index;
        while (i < this.elementCount) {
            if (elem.equals(this.elementData[this.elementOffset + i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int lastIndexOf(Object elem) {
        return this.lastIndexOf(elem, this.elementCount);
    }

    public final synchronized int lastIndexOf(Object elem, int index) {
        int i = index;
        while (--i >= 0) {
            if (!elem.equals(this.elementData[this.elementOffset + i])) continue;
            return i;
        }
        return -1;
    }

    public final synchronized Object elementAt(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        try {
            return this.elementData[this.elementOffset + index];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
    }

    public final synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementOffset];
    }

    public final synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementOffset + this.elementCount - 1];
    }

    public final synchronized void setElementAt(Object obj, int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        this.elementData[this.elementOffset + index] = obj;
    }

    public final synchronized void removeElementAt(int index) {
        if (index == 0) {
            this.elementData[this.elementOffset] = null;
            ++this.elementOffset;
            --this.elementCount;
            return;
        }
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount);
        }
        int j = this.elementCount - index - 1;
        if (j > 0) {
            System.arraycopy(this.elementData, this.elementOffset + index + 1, this.elementData, this.elementOffset + index, j);
        }
        --this.elementCount;
        this.elementData[this.elementOffset + this.elementCount] = null;
        if (this.elementCount == 0) {
            this.elementOffset = 0;
        }
    }

    public final synchronized void insertElementAt(Object obj, int index) {
        if (index >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.elementCount + 1);
        }
        if (index == 0 && this.elementOffset > 0) {
            --this.elementOffset;
            this.elementData[this.elementOffset] = obj;
        } else {
            this.ensureCapacity(this.elementCount + 1);
            System.arraycopy(this.elementData, this.elementOffset + index, this.elementData, this.elementOffset + index + 1, this.elementCount - index);
            this.elementData[this.elementOffset + index] = obj;
        }
        ++this.elementCount;
    }

    public final synchronized void addElement(Object obj) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementOffset + this.elementCount] = obj;
        ++this.elementCount;
    }

    public final synchronized boolean removeElement(Object obj) {
        int i = this.indexOf(obj);
        if (i == -1) {
            return false;
        }
        this.removeElementAt(i);
        return true;
    }

    public final synchronized void removeAllElements() {
        int i = 0;
        while (i < this.elementCount) {
            this.elementData[this.elementOffset + i] = null;
            ++i;
        }
        this.elementCount = 0;
        this.elementOffset = 0;
    }

    public synchronized Object clone() {
        try {
            FlexVector fv = (FlexVector)super.clone();
            fv.elementData = new Object[this.elementCount];
            fv.elementOffset = 0;
            System.arraycopy(this.elementData, this.elementOffset, fv.elementData, 0, this.elementCount);
            return fv;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final synchronized String toString() {
        int max = this.size() - 1;
        StringBuffer buf = new StringBuffer();
        Enumeration e = this.elements();
        buf.append("[");
        int i = 0;
        while (i <= max) {
            String s = e.nextElement().toString();
            buf.append(s);
            if (i < max) {
                buf.append(", ");
            }
            ++i;
        }
        buf.append("]");
        return buf.toString();
    }
}

