/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import java.util.Random;

public class IntGlide {
    private final int scale = 32;
    private int low;
    private int high;
    private int maxdelta;
    private int value;
    private int delta;
    private static Random random = new Random();

    public IntGlide(int low, int high, int maxdelta, int value) {
        this.low = low * 32;
        this.high = high * 32;
        this.maxdelta = maxdelta * 32;
        this.value = value * 32;
        this.validate();
        this.newDelta();
    }

    public IntGlide(int low, int high, int maxdelta) {
        this(low, high, maxdelta, Math.abs(random.nextInt()) % (high - low + 1) + low);
    }

    private void validate() {
        if (this.high < this.low) {
            int t = this.high;
            this.high = this.low;
            this.low = t;
        }
        if (this.maxdelta < 1) {
            this.maxdelta = 1;
        }
    }

    public int next() {
        int i = 0;
        while (i < 10) {
            int newval = this.value + this.delta;
            if (newval >= this.low && newval <= this.high) {
                this.value = newval;
                return this.value / 32;
            }
            this.newDelta();
            ++i;
        }
        if (this.value < this.low) {
            this.value = this.low;
        } else if (this.value > this.high) {
            this.value = this.high;
        }
        return this.value / 32;
    }

    private void newDelta() {
        this.delta = Math.abs(random.nextInt()) % (this.maxdelta * 2) - this.maxdelta;
        if (this.delta <= 0) {
            --this.delta;
        }
    }
}

