/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Filters.ImageFilterPlus;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;

public class Margin
extends ImageFilterPlus {
    private Color color;
    private int size;
    private int width;
    private int height;
    private int newWidth;
    private boolean started = false;

    public Margin(ImageProducer producer, Color color, int size) {
        super(producer, true);
        this.color = color;
        this.size = size;
    }

    public void setDimensions(int width, int height) {
        this.width = width;
        this.height = height;
        this.newWidth = width + this.size * 2;
        this.consumer.setDimensions(this.newWidth, height + this.size * 2);
    }

    private void start() {
        this.started = true;
        int rgb = this.color.getRGB();
        int[] fullRow = new int[this.newWidth];
        int col = 0;
        while (col < this.newWidth) {
            fullRow[col] = rgb;
            ++col;
        }
        int row = 0;
        while (row < this.size) {
            this.consumer.setPixels(0, row, this.newWidth, 1, ImageFilterPlus.rgbModel, fullRow, 0, this.newWidth);
            this.consumer.setPixels(0, this.size + this.height + row, this.newWidth, 1, ImageFilterPlus.rgbModel, fullRow, 0, this.newWidth);
            ++row;
        }
        int[] sideRow = new int[this.size];
        int col2 = 0;
        while (col2 < this.size) {
            sideRow[col2] = rgb;
            ++col2;
        }
        int row2 = 0;
        while (row2 < this.height) {
            this.consumer.setPixels(0, this.size + row2, this.size, 1, ImageFilterPlus.rgbModel, sideRow, 0, this.size);
            this.consumer.setPixels(this.size + this.width, this.size + row2, this.size, 1, ImageFilterPlus.rgbModel, sideRow, 0, this.size);
            ++row2;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(x + this.size, y + this.size, w, h, model, pixels, off, scansize);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        if (!this.started) {
            this.start();
        }
        this.consumer.setPixels(x + this.size, y + this.size, w, h, model, pixels, off, scansize);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Margin.usage();
        }
        Margin filter = new Margin(null, Color.black, Integer.parseInt(args[0]));
        System.exit(ImageFilterPlus.filterStream(System.in, System.out, filter));
    }

    private static void usage() {
        System.err.println("usage: Margin <size>");
        System.exit(1);
    }
}

