/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.GenericCloneable;
import Acme.PsgException;

class PsgMatrix
extends GenericCloneable {
    public double xx = 1.0;
    public double xy = 0.0;
    public double yx = 0.0;
    public double yy = 1.0;
    public double tx = 0.0;
    public double ty = 0.0;

    public PsgMatrix multiply(PsgMatrix b) {
        PsgMatrix r = new PsgMatrix();
        r.xx = this.xx * b.xx + this.xy * b.yx;
        r.xy = this.xx * b.xy + this.xy * b.yy;
        r.yy = this.yx * b.xy + this.yy * b.yy;
        r.yx = this.yx * b.xx + this.yy * b.yx;
        r.tx = this.tx * b.xx + this.ty * b.yx + b.tx;
        r.ty = this.tx * b.xy + this.ty * b.yy + b.ty;
        return r;
    }

    public PsgMatrix invert() throws PsgException {
        PsgMatrix r = new PsgMatrix();
        double det = this.xx * this.yy - this.xy * this.yx;
        if (det == 0.0) {
            throw new PsgException("undefined result");
        }
        r.xx = this.yy / det;
        r.xy = -this.xy / det;
        r.yx = -this.yx / det;
        r.yy = this.xx / det;
        r.tx = -(this.tx * r.xx + this.ty * r.yx);
        r.ty = -(this.tx * r.xy + this.ty * r.yy);
        return r;
    }
}

