/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.SerialUtilsTest;
import Acme.Serializable;
import Acme.Versioned;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SerialUtils {
    private static String tagNull = "Null";
    private static String tagString = "String";
    private static String tagArrayObject = "ArrayObject";
    private static String tagArrayByte = "ArrayByte";
    private static String tagArrayChar = "ArrayChar";
    private static String tagArrayShort = "ArrayShort";
    private static String tagArrayInt = "ArrayInt";
    private static String tagArrayLong = "ArrayLong";
    private static String tagArrayFloat = "ArrayFloat";
    private static String tagArrayDouble = "ArrayDouble";

    private static String getIdentifier(Class cl) {
        try {
            Object o = cl.newInstance();
            if (o instanceof Versioned) {
                Versioned v = (Versioned)o;
                return String.valueOf(cl.getName()) + " " + v.getVersion();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        return cl.getName();
    }

    private static void serializeHeaderString(String str, DataOutputStream dout) throws IOException {
        dout.writeUTF("[" + str);
    }

    private static void serializeHeader(Class cl, DataOutputStream dout) throws IOException {
        SerialUtils.serializeHeaderString(SerialUtils.getIdentifier(cl), dout);
    }

    private static void serializeTrailerString(String str, DataOutputStream dout) throws IOException {
        dout.writeUTF("]");
    }

    private static void serializeTrailer(Class cl, DataOutputStream dout) throws IOException {
        SerialUtils.serializeTrailerString(SerialUtils.getIdentifier(cl), dout);
    }

    private static void serializeNull(DataOutputStream dout) throws IOException {
        SerialUtils.serializeHeaderString(tagNull, dout);
        SerialUtils.serializeTrailerString(tagNull, dout);
    }

    public static void serializeObject(Serializable ser, DataOutputStream dout) throws IOException {
        if (ser == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeader(ser.getClass(), dout);
        ser.serialize(dout);
        SerialUtils.serializeTrailer(ser.getClass(), dout);
    }

    public static void serializeString(String str, DataOutputStream dout) throws IOException {
        if (str == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagString, dout);
        dout.writeUTF(str);
        SerialUtils.serializeTrailerString(tagString, dout);
    }

    public static void serializeBoolean(boolean b, DataOutputStream dout) throws IOException {
        dout.writeBoolean(b);
    }

    public static void serializeByte(byte b, DataOutputStream dout) throws IOException {
        dout.writeByte(b);
    }

    public static void serializeChar(char c, DataOutputStream dout) throws IOException {
        dout.writeChar(c);
    }

    public static void serializeShort(short s, DataOutputStream dout) throws IOException {
        dout.writeShort(s);
    }

    public static void serializeInt(int i, DataOutputStream dout) throws IOException {
        dout.writeInt(i);
    }

    public static void serializeLong(long l, DataOutputStream dout) throws IOException {
        dout.writeLong(l);
    }

    public static void serializeFloat(float f, DataOutputStream dout) throws IOException {
        dout.writeFloat(f);
    }

    public static void serializeDouble(double d, DataOutputStream dout) throws IOException {
        dout.writeDouble(d);
    }

    public static void serializeArrayObject(Serializable[] ao, DataOutputStream dout) throws IOException {
        if (ao == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayObject, dout);
        dout.writeShort(ao.length);
        int i = 0;
        while (i < ao.length) {
            SerialUtils.serializeObject(ao[i], dout);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayObject, dout);
    }

    public static void serializeArrayByte(byte[] ab, DataOutputStream dout) throws IOException {
        if (ab == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayByte, dout);
        dout.writeShort(ab.length);
        int i = 0;
        while (i < ab.length) {
            dout.writeByte(ab[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayByte, dout);
    }

    public static void serializeArrayChar(char[] ac, DataOutputStream dout) throws IOException {
        if (ac == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayChar, dout);
        dout.writeShort(ac.length);
        int i = 0;
        while (i < ac.length) {
            dout.writeChar(ac[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayChar, dout);
    }

    public static void serializeArrayShort(short[] as, DataOutputStream dout) throws IOException {
        if (as == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayShort, dout);
        dout.writeShort(as.length);
        int i = 0;
        while (i < as.length) {
            dout.writeShort(as[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayShort, dout);
    }

    public static void serializeArrayInt(int[] ai, DataOutputStream dout) throws IOException {
        if (ai == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayInt, dout);
        dout.writeShort(ai.length);
        int i = 0;
        while (i < ai.length) {
            dout.writeInt(ai[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayInt, dout);
    }

    public static void serializeArrayLong(long[] al, DataOutputStream dout) throws IOException {
        if (al == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayLong, dout);
        dout.writeShort(al.length);
        int i = 0;
        while (i < al.length) {
            dout.writeLong(al[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayLong, dout);
    }

    public static void serializeArrayFloat(float[] af, DataOutputStream dout) throws IOException {
        if (af == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayFloat, dout);
        dout.writeShort(af.length);
        int i = 0;
        while (i < af.length) {
            dout.writeFloat(af[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayFloat, dout);
    }

    public static void serializeArrayDouble(double[] ad, DataOutputStream dout) throws IOException {
        if (ad == null) {
            SerialUtils.serializeNull(dout);
            return;
        }
        SerialUtils.serializeHeaderString(tagArrayDouble, dout);
        dout.writeShort(ad.length);
        int i = 0;
        while (i < ad.length) {
            dout.writeDouble(ad[i]);
            ++i;
        }
        SerialUtils.serializeTrailerString(tagArrayDouble, dout);
    }

    private static boolean deserializeHeaderString(String str, DataInputStream din) throws IOException {
        String s2 = din.readUTF();
        if (s2.equals("[" + tagNull)) {
            return false;
        }
        if (!s2.equals("[" + str)) {
            throw new IOException("bogus serialization header");
        }
        return true;
    }

    public static boolean deserializeHeader(Class cl, DataInputStream din) throws IOException {
        return SerialUtils.deserializeHeaderString(SerialUtils.getIdentifier(cl), din);
    }

    private static void deserializeTrailerString(String str, DataInputStream din) throws IOException {
        String s2 = din.readUTF();
        if (!s2.equals("]")) {
            throw new IOException("bogus serialization trailer");
        }
    }

    public static void deserializeTrailer(Class cl, DataInputStream din) throws IOException {
        SerialUtils.deserializeTrailerString(SerialUtils.getIdentifier(cl), din);
    }

    public static Serializable deserializeObject(Class cl, DataInputStream din) throws IOException {
        Serializable o;
        if (SerialUtils.deserializeHeader(cl, din)) {
            try {
                o = (Serializable)cl.newInstance();
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.toString());
            }
            catch (InstantiationException e) {
                throw new IOException(e.toString());
            }
            o.deserialize(din);
        } else {
            o = null;
        }
        SerialUtils.deserializeTrailer(cl, din);
        return o;
    }

    public static String deserializeString(DataInputStream din) throws IOException {
        String str = SerialUtils.deserializeHeaderString(tagString, din) ? din.readUTF() : null;
        SerialUtils.deserializeTrailerString(tagString, din);
        return str;
    }

    public static boolean deserializeBoolean(DataInputStream din) throws IOException {
        return din.readBoolean();
    }

    public static byte deserializeByte(DataInputStream din) throws IOException {
        return din.readByte();
    }

    public static char deserializeChar(DataInputStream din) throws IOException {
        return din.readChar();
    }

    public static short deserializeShort(DataInputStream din) throws IOException {
        return din.readShort();
    }

    public static int deserializeInt(DataInputStream din) throws IOException {
        return din.readInt();
    }

    public static long deserializeLong(DataInputStream din) throws IOException {
        return din.readLong();
    }

    public static float deserializeFloat(DataInputStream din) throws IOException {
        return din.readFloat();
    }

    public static double deserializeDouble(DataInputStream din) throws IOException {
        return din.readDouble();
    }

    public static Serializable[] deserializeArrayObject(DataInputStream din) throws IOException {
        Serializable[] ao;
        if (SerialUtils.deserializeHeaderString(tagArrayObject, din)) {
            int len = din.readShort();
            ao = new Serializable[len];
            int i = 0;
            while (i < len) {
                ao[i] = SerialUtils.deserializeObject(null, din);
                ++i;
            }
        } else {
            ao = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayObject, din);
        return ao;
    }

    public static byte[] deserializeArrayByte(DataInputStream din) throws IOException {
        byte[] ab;
        if (SerialUtils.deserializeHeaderString(tagArrayByte, din)) {
            int len = din.readShort();
            ab = new byte[len];
            int i = 0;
            while (i < len) {
                ab[i] = din.readByte();
                ++i;
            }
        } else {
            ab = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayByte, din);
        return ab;
    }

    public static char[] deserializeArrayChar(DataInputStream din) throws IOException {
        char[] ac;
        if (SerialUtils.deserializeHeaderString(tagArrayChar, din)) {
            int len = din.readShort();
            ac = new char[len];
            int i = 0;
            while (i < len) {
                ac[i] = din.readChar();
                ++i;
            }
        } else {
            ac = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayChar, din);
        return ac;
    }

    public static short[] deserializeArrayShort(DataInputStream din) throws IOException {
        short[] as;
        if (SerialUtils.deserializeHeaderString(tagArrayShort, din)) {
            int len = din.readShort();
            as = new short[len];
            int i = 0;
            while (i < len) {
                as[i] = din.readShort();
                ++i;
            }
        } else {
            as = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayShort, din);
        return as;
    }

    public static int[] deserializeArrayInt(DataInputStream din) throws IOException {
        int[] ai;
        if (SerialUtils.deserializeHeaderString(tagArrayInt, din)) {
            int len = din.readShort();
            ai = new int[len];
            int i = 0;
            while (i < len) {
                ai[i] = din.readInt();
                ++i;
            }
        } else {
            ai = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayInt, din);
        return ai;
    }

    public static long[] deserializeArrayLong(DataInputStream din) throws IOException {
        long[] al;
        if (SerialUtils.deserializeHeaderString(tagArrayLong, din)) {
            int len = din.readShort();
            al = new long[len];
            int i = 0;
            while (i < len) {
                al[i] = din.readLong();
                ++i;
            }
        } else {
            al = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayLong, din);
        return al;
    }

    public static float[] deserializeArrayFloat(DataInputStream din) throws IOException {
        float[] af;
        if (SerialUtils.deserializeHeaderString(tagArrayFloat, din)) {
            int len = din.readShort();
            af = new float[len];
            int i = 0;
            while (i < len) {
                af[i] = din.readFloat();
                ++i;
            }
        } else {
            af = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayFloat, din);
        return af;
    }

    public static double[] deserializeArrayDouble(DataInputStream din) throws IOException {
        double[] ad;
        if (SerialUtils.deserializeHeaderString(tagArrayDouble, din)) {
            int len = din.readShort();
            ad = new double[len];
            int i = 0;
            while (i < len) {
                ad[i] = din.readDouble();
                ++i;
            }
        } else {
            ad = null;
        }
        SerialUtils.deserializeTrailerString(tagArrayDouble, din);
        return ad;
    }

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("-s")) {
            long[] al1 = new long[]{0L, 1L, 2L};
            long[] al2 = new long[]{3L, 4L, 5L, 6L};
            SerialUtilsTest t = new SerialUtilsTest(null, "Yo", 23, '@', 23456, 234567890, 234567890123L, 23.4567f, 23.4567890123, al2);
            t = new SerialUtilsTest(t, "Hi there", 123, 'x', 12345, 123456789, 123456789012L, 123.456f, 123.456789012, al1);
            DataOutputStream dout = new DataOutputStream(System.out);
            try {
                SerialUtils.serializeObject(t, dout);
                dout.flush();
            }
            catch (IOException e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
        } else if (args.length == 1 && args[0].equals("-d")) {
            SerialUtilsTest t = new SerialUtilsTest();
            DataInputStream din = new DataInputStream(System.in);
            try {
                t = (SerialUtilsTest)SerialUtils.deserializeObject(t.getClass(), din);
            }
            catch (IOException e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            System.out.println(t.toString());
        } else {
            System.err.println("usage:  SerialUtils -s|-d");
            System.exit(1);
        }
        System.exit(0);
    }
}

