/*
 * Decompiled with CFR 0.152.
 */
package Acme.Serve.servlet.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class ChunkedOutputStream
extends BufferedOutputStream {
    private Vector footerNames = new Vector();
    private Vector footerValues = new Vector();
    private static final byte[] crlf = new byte[]{13, 10};

    public ChunkedOutputStream(OutputStream out) {
        super(out);
    }

    public ChunkedOutputStream(OutputStream out, int size) {
        super(out, size);
    }

    public synchronized void flush() throws IOException {
        if (this.count != 0) {
            this.writeBuf(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public void setFooter(String name, String value) {
        this.footerNames.addElement(name);
        this.footerValues.addElement(value);
    }

    public void done() throws IOException {
        this.flush();
        PrintStream pout = new PrintStream(this.out);
        pout.println("0");
        if (this.footerNames.size() > 0) {
            int i = 0;
            while (i < this.footerNames.size()) {
                String name = (String)this.footerNames.elementAt(i);
                String value = (String)this.footerValues.elementAt(i);
                pout.println(String.valueOf(name) + ": " + value);
                ++i;
            }
        }
        this.footerNames = null;
        this.footerValues = null;
        pout.println("");
        pout.flush();
    }

    public void close() throws IOException {
        if (this.footerNames != null) {
            this.done();
        }
        super.close();
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        int avail = this.buf.length - this.count;
        if (len <= avail) {
            System.arraycopy(b, off, this.buf, this.count, len);
            this.count += len;
            return;
        }
        this.flush();
        this.writeBuf(b, off, len);
    }

    private void writeBuf(byte[] b, int off, int len) throws IOException {
        String lenStr = Integer.toString(len, 16);
        byte[] lenBytes = lenStr.getBytes();
        this.out.write(lenBytes);
        this.out.write(crlf);
        if (len != 0) {
            this.out.write(b, off, len);
        }
        this.out.write(crlf);
        this.out.flush();
    }
}

