/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.SyslogException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Syslog {
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_PRIMASK = 7;
    public static final int LOG_KERN = 0;
    public static final int LOG_USER = 8;
    public static final int LOG_MAIL = 16;
    public static final int LOG_DAEMON = 24;
    public static final int LOG_AUTH = 32;
    public static final int LOG_SYSLOG = 40;
    public static final int LOG_LPR = 48;
    public static final int LOG_NEWS = 56;
    public static final int LOG_UUCP = 64;
    public static final int LOG_CRON = 120;
    public static final int LOG_LOCAL0 = 128;
    public static final int LOG_LOCAL1 = 136;
    public static final int LOG_LOCAL2 = 144;
    public static final int LOG_LOCAL3 = 152;
    public static final int LOG_LOCAL4 = 160;
    public static final int LOG_LOCAL5 = 168;
    public static final int LOG_LOCAL6 = 176;
    public static final int LOG_LOCAL7 = 184;
    public static final int LOG_FACMASK = 1016;
    public static final int LOG_PID = 1;
    public static final int LOG_CONS = 2;
    public static final int LOG_NDELAY = 8;
    public static final int LOG_NOWAIT = 16;
    private static final int PORT = 514;
    private String ident;
    private int logopt;
    private int facility;
    private InetAddress address;
    private DatagramPacket packet;
    private DatagramSocket socket;

    public Syslog(String ident, int logopt, int facility) throws SyslogException {
        this.ident = ident == null ? new String(Thread.currentThread().getName()) : ident;
        this.logopt = logopt;
        this.facility = facility;
        try {
            this.address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new SyslogException("error locating localhost: " + e.getMessage());
        }
        try {
            this.socket = new DatagramSocket();
            return;
        }
        catch (SocketException e) {
            throw new SyslogException("error creating syslog udp socket: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SyslogException("error creating syslog udp socket: " + e.getMessage());
        }
    }

    public void syslog(int priority, String msg) throws SyslogException {
        int pricode = this.MakePriorityCode(this.facility, priority);
        Integer priObj = new Integer(pricode);
        int length = 4 + this.ident.length() + msg.length() + 1;
        byte[] data = new byte[length += pricode > 99 ? 3 : (pricode > 9 ? 2 : 1)];
        int idx = 0;
        data[idx++] = 60;
        String strObj = Integer.toString(priObj);
        strObj.getBytes(0, strObj.length(), data, idx);
        idx += strObj.length();
        data[idx++] = 62;
        this.ident.getBytes(0, this.ident.length(), data, idx);
        idx += this.ident.length();
        data[idx++] = 58;
        data[idx++] = 32;
        msg.getBytes(0, msg.length(), data, idx);
        data[idx += msg.length()] = 0;
        this.packet = new DatagramPacket(data, length, this.address, 514);
        try {
            this.socket.send(this.packet);
            return;
        }
        catch (IOException e) {
            throw new SyslogException("error sending message: '" + e.getMessage() + "'");
        }
    }

    private int MakePriorityCode(int facility, int priority) {
        return facility & 0x3F8 | priority;
    }
}

