/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.emma.report.MethodItem;
import com.vladium.util.IntObjectMap;
import java.util.Iterator;

public final class SrcFileItem
extends Item {
    private final String m_name;
    private final String m_fullVMName;
    private IntObjectMap m_lineCoverage;
    private int m_firstLine;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(2, "srcfile", 31L);

    public SrcFileItem(IItem parent, String name, String fullVMName) {
        super(parent);
        this.m_name = name;
        this.m_fullVMName = fullVMName;
    }

    public String getName() {
        return this.m_name;
    }

    public String getFullVMName() {
        return this.m_fullVMName;
    }

    public int getFirstLine() {
        if (this.m_firstLine == 0) {
            this.getAggregate(7);
        }
        return this.m_firstLine;
    }

    public IntObjectMap getLineCoverage() {
        if (this.m_lineCoverage == null) {
            this.getAggregate(7);
        }
        return this.m_lineCoverage;
    }

    public int getAggregate(int type) {
        int[] aggregates = this.m_aggregates;
        int value = aggregates[type];
        if (value < 0) {
            switch (type) {
                case 5: 
                case 11: {
                    aggregates[11] = this.getChildCount();
                    value = 0;
                    Iterator children = this.getChildren();
                    while (children.hasNext()) {
                        value += ((IItem)children.next()).getAggregate(5);
                    }
                    aggregates[5] = value;
                    return aggregates[type];
                }
                case 12: {
                    aggregates[12] = 1;
                    return 1;
                }
                case 1: 
                case 3: 
                case 7: {
                    int lineCount;
                    IntObjectMap fldata = new IntObjectMap();
                    Iterator classes = this.getChildren();
                    while (classes.hasNext()) {
                        ClassItem cls = (ClassItem)classes.next();
                        boolean[][] ccoverage = cls.getCoverage();
                        ClassDescriptor clsdesc = cls.getClassDescriptor();
                        MethodDescriptor[] methoddescs = clsdesc.getMethods();
                        Iterator methods = cls.getChildren();
                        while (methods.hasNext()) {
                            MethodItem method = (MethodItem)methods.next();
                            int methodID = method.getID();
                            boolean[] mcoverage = ccoverage == null ? null : ccoverage[methodID];
                            MethodDescriptor methoddesc = methoddescs[methodID];
                            int[] mbsizes = methoddesc.getBlockSizes();
                            IntObjectMap mlineMap = methoddesc.getLineMap();
                            int[] mlines = mlineMap.keys();
                            int mlLimit = mlines.length;
                            for (int ml = 0; ml < mlLimit; ++ml) {
                                int mline = mlines[ml];
                                int[] data = (int[])fldata.get(mline);
                                if (data == null) {
                                    data = new int[4];
                                    fldata.put(mline, data);
                                }
                                int[] lblocks = (int[])mlineMap.get(mline);
                                int bCount = lblocks.length;
                                data[0] = data[0] + bCount;
                                for (int bID = 0; bID < bCount; ++bID) {
                                    int block = lblocks[bID];
                                    boolean bcovered = mcoverage != null && mcoverage[block];
                                    int instr = mbsizes[block];
                                    data[1] = data[1] + instr;
                                    if (!bcovered) continue;
                                    data[2] = data[2] + 1;
                                    data[3] = data[3] + instr;
                                }
                            }
                        }
                    }
                    aggregates[7] = lineCount = fldata.size();
                    int coverageLineCount = 0;
                    int coverageLineInstr = 0;
                    IntObjectMap lineCoverage = new IntObjectMap(lineCount);
                    int firstLine = Integer.MAX_VALUE;
                    int[] clines = fldata.keys();
                    for (int cl = 0; cl < lineCount; ++cl) {
                        int lcoverageStatus;
                        int cline = clines[cl];
                        int[] data = (int[])fldata.get(cline);
                        int ltotalCount = data[0];
                        int ltotalInstr = data[1];
                        int lcoverageCount = data[2];
                        int lcoverageInstr = data[3];
                        if (lcoverageInstr > 0) {
                            coverageLineCount += 10000 * lcoverageCount / ltotalCount;
                            coverageLineInstr += 10000 * lcoverageInstr / ltotalInstr;
                        }
                        Object lcoverageRatio = null;
                        if (lcoverageInstr == 0) {
                            lcoverageStatus = 0;
                        } else if (lcoverageInstr == ltotalInstr) {
                            lcoverageStatus = 2;
                        } else {
                            lcoverageStatus = 1;
                            lcoverageRatio = new int[][]{{ltotalCount, lcoverageCount}, {ltotalInstr, lcoverageInstr}};
                        }
                        lineCoverage.put(cline, new LineCoverageData(lcoverageStatus, (int[][])lcoverageRatio));
                        if (cline >= firstLine) continue;
                        firstLine = cline;
                    }
                    this.m_lineCoverage = lineCoverage;
                    this.m_firstLine = firstLine;
                    aggregates[1] = coverageLineCount;
                    aggregates[3] = coverageLineInstr;
                    return aggregates[type];
                }
            }
            return super.getAggregate(type);
        }
        return value;
    }

    public void accept(IItemVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }

    public final class LineCoverageData {
        public static final int LINE_COVERAGE_ZERO = 0;
        public static final int LINE_COVERAGE_PARTIAL = 1;
        public static final int LINE_COVERAGE_COMPLETE = 2;
        public final int m_coverageStatus;
        public final int[][] m_coverageRatio;

        LineCoverageData(int coverageStatus, int[][] coverageRatio) {
            this.m_coverageStatus = coverageStatus;
            this.m_coverageRatio = coverageRatio;
        }
    }
}

