/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.ant.GenericCfg;
import com.vladium.emma.ant.PropertyElement;
import com.vladium.emma.ant.SuppressableTask;
import com.vladium.emma.ant.VerbosityCfg;
import com.vladium.emma.instr.FilterCfg;
import com.vladium.emma.report.IReportEnums;
import com.vladium.emma.report.ReportCfg;
import com.vladium.util.IProperties;
import com.vladium.util.Strings;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class emmajavaTask
extends Java {
    private Path m_classpath;
    private String m_classname;
    private File m_jar;
    private Commandline m_appArgs;
    private boolean m_fork;
    private boolean m_forkUserOverride;
    private boolean m_enabled;
    private Path m_libClasspath;
    private VerbosityCfg m_verbosityCfg;
    private GenericCfg m_genericCfg;
    private FilterCfg m_filterCfg;
    private ReportCfg m_reportCfg;
    private boolean m_scanCoveragePath;
    private boolean m_dumpSessionData;
    private File m_outFile;
    private Boolean m_outFileMerge;

    public void init() throws BuildException {
        super.init();
        this.m_verbosityCfg = new VerbosityCfg();
        this.m_genericCfg = new GenericCfg((Task)this);
        this.m_filterCfg = new FilterCfg((Task)this);
        this.m_reportCfg = new ReportCfg(this.project, (Task)this);
        this.setEnabled(true);
    }

    public void execute() throws BuildException {
        this.log("[EMMA v2.0, build 4217 (2004/07/17 12:19:29)]", 3);
        if (this.getClasspath() == null) {
            throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + ": this task requires 'classpath' attribute to be set", this.location).fillInStackTrace();
        }
        if (this.isEnabled()) {
            Path srcpath;
            String[] specs;
            if (this.m_forkUserOverride && !this.m_fork) {
                this.log(this.getTaskName() + ": 'fork=\"false\"' attribute setting ignored (this task always forks)", 1);
            }
            super.setFork(true);
            Path libClasspath = this.m_libClasspath;
            if (libClasspath != null && libClasspath.size() > 0) {
                super.createClasspath().append(libClasspath);
            }
            super.setClassname("emmarun");
            String reportTypes = Strings.toListForm((String[])this.m_reportCfg.getReportTypes(), (char)',');
            if (reportTypes == null || reportTypes.length() == 0) {
                reportTypes = "txt";
            }
            super.createArg().setValue("-r");
            super.createArg().setValue(reportTypes);
            if (this.m_scanCoveragePath) {
                super.createArg().setValue("-f");
            }
            if (this.m_dumpSessionData) {
                super.createArg().setValue("-raw");
                if (this.m_outFile != null) {
                    super.createArg().setValue("-out");
                    super.createArg().setValue(this.m_outFile.getAbsolutePath());
                }
                if (this.m_outFileMerge != null) {
                    super.createArg().setValue("-merge");
                    super.createArg().setValue(this.m_outFileMerge != false ? "y" : "n");
                }
            } else {
                if (this.m_outFile != null) {
                    this.log(this.getTaskName() + ": output file attribute ignored ('fullmetadata=\"true\"' not specified)", 1);
                }
                if (this.m_outFileMerge != null) {
                    this.log(this.getTaskName() + ": merge attribute setting ignored ('fullmetadata=\"true\"' not specified)", 1);
                }
            }
            if ((specs = this.m_filterCfg.getFilterSpecs()) != null && specs.length > 0) {
                super.createArg().setValue("-ix");
                super.createArg().setValue(Strings.toListForm((String[])specs, (char)','));
            }
            if ((srcpath = this.m_reportCfg.getSourcepath()) != null) {
                super.createArg().setValue("-sp");
                super.createArg().setValue(Strings.toListForm((String[])srcpath.list(), (char)','));
            }
            IProperties reportSettings = this.m_reportCfg.getReportSettings();
            IProperties genericSettings = this.m_genericCfg.getGenericSettings();
            IProperties fileSettings = this.m_genericCfg.getFileSettings();
            IProperties verbositySettings = this.m_verbosityCfg.getSettings();
            IProperties settings = IProperties.Factory.combine((IProperties)reportSettings, (IProperties)IProperties.Factory.combine((IProperties)verbositySettings, (IProperties)IProperties.Factory.combine((IProperties)genericSettings, (IProperties)fileSettings)));
            String[] argForm = settings.toAppArgsForm("-D");
            if (argForm.length > 0) {
                for (int a = 0; a < argForm.length; ++a) {
                    super.createArg().setValue(argForm[a]);
                }
            }
            super.createArg().setValue("-cp");
            super.createArg().setPath(this.getClasspath());
            if (this.getClassname() != null) {
                super.createArg().setValue(this.getClassname());
            } else if (this.getJar() != null) {
                super.createArg().setValue("-jar");
                super.createArg().setValue(this.getJar().getAbsolutePath());
            } else {
                throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + "either 'jar' or 'classname' attribute must be set", this.location).fillInStackTrace();
            }
            if (this.m_appArgs != null) {
                String[] args = this.m_appArgs.getArguments();
                for (int a = 0; a < args.length; ++a) {
                    super.createArg().setValue(args[a]);
                }
            }
        } else {
            super.setFork(this.m_fork);
            super.createClasspath().append(this.getClasspath());
            if (this.getClassname() != null) {
                super.setClassname(this.getClassname());
            } else if (this.getJar() != null) {
                super.setJar(this.getJar());
            } else {
                throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + "either 'jar' or 'classname' attribute must be set", this.location).fillInStackTrace();
            }
            if (this.m_appArgs != null) {
                String[] args = this.m_appArgs.getArguments();
                for (int a = 0; a < args.length; ++a) {
                    super.createArg().setValue(args[a]);
                }
            }
        }
        super.execute();
    }

    public void setClassname(String classname) {
        if (this.getJar() != null) {
            throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + "'jar' and 'classname' attributes cannot be set at the same time", this.location).fillInStackTrace();
        }
        this.m_classname = classname;
    }

    public void setJar(File file) {
        if (this.getClassname() != null) {
            throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + "'jar' and 'classname' attributes cannot be set at the same time", this.location).fillInStackTrace();
        }
        this.m_jar = file;
    }

    public void setClasspath(Path path) {
        if (this.m_classpath == null) {
            this.m_classpath = path;
        } else {
            this.m_classpath.append(path);
        }
    }

    public void setClasspathRef(Reference ref) {
        this.createClasspath().setRefid(ref);
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.project);
        }
        return this.m_classpath.createPath();
    }

    public void setArgs(String args) {
        throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + ": disallows using <java>'s deprecated 'args' attribute", this.location).fillInStackTrace();
    }

    public final void setFork(boolean fork) {
        this.m_fork = fork;
        this.m_forkUserOverride = true;
    }

    public final Commandline.Argument createArg() {
        if (this.m_appArgs == null) {
            this.m_appArgs = new Commandline();
        }
        return this.m_appArgs.createArgument();
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public final void setProperties(File file) {
        this.m_genericCfg.setProperties(file);
    }

    public final PropertyElement createProperty() {
        return this.m_genericCfg.createProperty();
    }

    public void setVerbosity(VerbosityCfg.VerbosityAttribute verbosity) {
        this.m_verbosityCfg.setVerbosity(verbosity);
    }

    public void setVerbosityfilter(String filter) {
        this.m_verbosityCfg.setVerbosityfilter(filter);
    }

    public final void setLibclasspath(Path classpath) {
        if (this.m_libClasspath == null) {
            this.m_libClasspath = classpath;
        } else {
            this.m_libClasspath.append(classpath);
        }
    }

    public final void setLibclasspathRef(Reference ref) {
        if (this.m_libClasspath == null) {
            this.m_libClasspath = new Path(this.project);
        }
        this.m_libClasspath.createPath().setRefid(ref);
    }

    public void setFullmetadata(boolean full) {
        this.m_scanCoveragePath = full;
    }

    public void setDumpsessiondata(boolean dump) {
        this.m_dumpSessionData = dump;
    }

    public void setSessiondatafile(File file) {
        if (this.m_outFile != null) {
            throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + ": session data file attribute already set", this.location).fillInStackTrace();
        }
        this.m_outFile = file;
    }

    public void setOutfile(File file) {
        if (this.m_outFile != null) {
            throw (BuildException)SuppressableTask.newBuildException(this.getTaskName() + ": session data file attribute already set", this.location).fillInStackTrace();
        }
        this.m_outFile = file;
    }

    public void setMerge(boolean merge) {
        this.m_outFileMerge = merge ? Boolean.TRUE : Boolean.FALSE;
    }

    public final void setFilter(String filter) {
        this.m_filterCfg.setFilter(filter);
    }

    public final FilterCfg.filterElement createFilter() {
        return this.m_filterCfg.createFilter();
    }

    public final void setSourcepath(Path path) {
        this.m_reportCfg.setSourcepath(path);
    }

    public final void setSourcepathRef(Reference ref) {
        this.m_reportCfg.setSourcepathRef(ref);
    }

    public final Path createSourcepath() {
        return this.m_reportCfg.createSourcepath();
    }

    public final ReportCfg.Element_TXT createTxt() {
        return this.m_reportCfg.createTxt();
    }

    public final ReportCfg.Element_HTML createHtml() {
        return this.m_reportCfg.createHtml();
    }

    public final ReportCfg.Element_XML createXml() {
        return this.m_reportCfg.createXml();
    }

    public final void setUnits(IReportEnums.UnitsTypeAttribute units) {
        this.m_reportCfg.setUnits(units);
    }

    public final void setDepth(IReportEnums.DepthAttribute depth) {
        this.m_reportCfg.setDepth(depth);
    }

    public final void setColumns(String columns) {
        this.m_reportCfg.setColumns(columns);
    }

    public final void setSort(String sort) {
        this.m_reportCfg.setSort(sort);
    }

    public final void setMetrics(String metrics) {
        this.m_reportCfg.setMetrics(metrics);
    }

    public void setEncoding(String encoding) {
        this.m_reportCfg.setEncoding(encoding);
    }

    protected String getClassname() {
        return this.m_classname;
    }

    protected File getJar() {
        return this.m_jar;
    }

    protected Path getClasspath() {
        return this.m_classpath;
    }

    protected boolean isEnabled() {
        return this.m_enabled;
    }
}

