/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.APrintStream;
import Acme.Application;
import Acme.GuiUtils;
import Acme.MainFrame;
import Acme.NullInputStream;
import Acme.TextcompOutputStream;
import Acme.Utils;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.TextArea;
import java.io.PrintStream;

public class ApplicationApplet
extends Applet
implements Runnable {
    TextArea textArea;
    Application app;
    String[] args;
    Thread thread;

    public String getAppletInfo() {
        return String.valueOf(this.getClass().getName()) + " - running via ApplicationApplet - Copyright (C) 1996 by Jef Poskanzer <jef@acme.com>.  All rights reserved.";
    }

    public String[][] getParameterInfo() {
        String[][] info = new String[][]{{"CLASS", "Class", "the application to load"}, {"ARGS", "string", "the argument list"}};
        return info;
    }

    public void init() {
        String appName;
        GuiUtils.handleBgcolor(this);
        if (this.textArea == null) {
            this.makeTextArea();
        }
        if ((appName = this.getParameter("CLASS")) == null) {
            this.showStatus("Missing CLASS parameter");
            return;
        }
        if (appName.endsWith(".class")) {
            appName = appName.substring(0, appName.length() - 6).replace('/', '.');
        }
        if (appName.endsWith(".java")) {
            appName = appName.substring(0, appName.length() - 5).replace('/', '.');
        }
        try {
            this.app = (Application)Class.forName(appName).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.showStatus("Class not found: " + appName);
        }
        catch (ClassCastException e) {
            this.showStatus("Class cast problem: " + e.getMessage());
        }
        catch (InstantiationException e) {
            this.showStatus("Instantiation problem - " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.showStatus("Illegal class access - " + e.getMessage());
        }
        this.getArgs();
    }

    private void makeTextArea() {
        this.setLayout(new BorderLayout());
        this.textArea = new TextArea();
        this.textArea.setEditable(false);
        this.textArea.setFont(new Font("Courier", 0, 10));
        this.add("Center", this.textArea);
        this.validate();
    }

    public void getArgs() {
        String argList = this.getParameter("ARGS");
        if (argList == null) {
            this.args = new String[0];
            return;
        }
        this.args = Utils.splitStr(argList);
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
        }
    }

    public void run() {
        if (this.textArea == null) {
            this.makeTextArea();
        }
        if (this.app == null) {
            this.showStatus("No application defined");
            return;
        }
        if (this.args == null) {
            this.showStatus("No arguments defined");
            return;
        }
        NullInputStream in = new NullInputStream();
        APrintStream out = new APrintStream(new TextcompOutputStream(this.textArea));
        String appName = this.app.getClass().getName();
        this.showStatus(String.valueOf(appName) + " running...");
        out.println("% " + appName + " " + Utils.flattenStrarr(this.args));
        this.app.compat(this.args, in, out, out);
        ((PrintStream)out).print("% ");
        this.showStatus(String.valueOf(appName) + " done.");
    }

    public static void main(String[] args) {
        new MainFrame(new ApplicationApplet(), args, 400, 500);
    }
}

