/*
 * Decompiled with CFR 0.152.
 */
package Acme.Crypto;

import Acme.Crypto.StreamCipher;

public class Rc4Cipher
extends StreamCipher {
    private byte[] state = new byte[256];
    private int x;
    private int y;

    public Rc4Cipher(String keyStr) {
        super(256);
        this.setKey(keyStr);
    }

    public Rc4Cipher(byte[] key) {
        super(256);
        this.setKey(key);
    }

    public void setKey(byte[] key) {
        int counter = 0;
        while (counter < 256) {
            this.state[counter] = (byte)counter;
            ++counter;
        }
        this.x = 0;
        this.y = 0;
        int index1 = 0;
        int index2 = 0;
        counter = 0;
        while (counter < 256) {
            index2 = key[index1] + this.state[counter] + index2 & 0xFF;
            byte temp = this.state[counter];
            this.state[counter] = this.state[index2];
            this.state[index2] = temp;
            index1 = (index1 + 1) % key.length;
            ++counter;
        }
    }

    public byte encrypt(byte clearText) {
        return (byte)(clearText ^ this.state[this.nextState()]);
    }

    public byte decrypt(byte cipherText) {
        return (byte)(cipherText ^ this.state[this.nextState()]);
    }

    public void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff, int len) {
        int i = 0;
        while (i < len) {
            cipherText[cipherOff + i] = (byte)(clearText[clearOff + i] ^ this.state[this.nextState()]);
            ++i;
        }
    }

    public void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff, int len) {
        int i = 0;
        while (i < len) {
            clearText[clearOff + i] = (byte)(cipherText[cipherOff + i] ^ this.state[this.nextState()]);
            ++i;
        }
    }

    private int nextState() {
        this.x = this.x + 1 & 0xFF;
        this.y = this.y + this.state[this.x] & 0xFF;
        byte temp = this.state[this.x];
        this.state[this.x] = this.state[this.y];
        this.state[this.y] = temp;
        return this.state[this.x] + this.state[this.y] & 0xFF;
    }
}

