/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Encoders;

import Acme.JPM.Encoders.ImageEncoder;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;

public class PpmEncoder
extends ImageEncoder {
    public PpmEncoder(Image img, OutputStream out) throws IOException {
        super(img, out);
    }

    public PpmEncoder(ImageProducer prod, OutputStream out) throws IOException {
        super(prod, out);
    }

    void encodeStart(int width, int height) throws IOException {
        PpmEncoder.writeString(this.out, "P6\n");
        PpmEncoder.writeString(this.out, String.valueOf(width) + " " + height + "\n");
        PpmEncoder.writeString(this.out, "255\n");
    }

    static void writeString(OutputStream out, String str) throws IOException {
        byte[] buf = str.getBytes();
        out.write(buf);
    }

    void encodePixels(int x, int y, int w, int h, int[] rgbPixels, int off, int scansize) throws IOException {
        byte[] ppmPixels = new byte[w * 3];
        int row = 0;
        while (row < h) {
            int rowOff = off + row * scansize;
            int col = 0;
            while (col < w) {
                int i = rowOff + col;
                int j = col * 3;
                ppmPixels[j] = (byte)((rgbPixels[i] & 0xFF0000) >> 16);
                ppmPixels[j + 1] = (byte)((rgbPixels[i] & 0xFF00) >> 8);
                ppmPixels[j + 2] = (byte)(rgbPixels[i] & 0xFF);
                ++col;
            }
            this.out.write(ppmPixels);
            ++row;
        }
    }

    void encodeDone() throws IOException {
    }
}

