/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Filters;

import Acme.JPM.Decoders.PpmDecoder;
import Acme.JPM.Encoders.PpmEncoder;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageFilterPlus
extends ImageFilter {
    private ImageProducer producer;
    private boolean pixelOrderChanges;
    public static final ColorModel rgbModel = ColorModel.getRGBdefault();

    public ImageFilterPlus(ImageProducer producer) {
        this(producer, false);
    }

    public ImageFilterPlus(ImageProducer producer, boolean pixelOrderChanges) {
        this.setSource(producer);
        this.pixelOrderChanges = pixelOrderChanges;
    }

    public ImageProducer getSource() {
        return this.producer;
    }

    public void setSource(ImageProducer producer) {
        this.producer = producer;
    }

    public void setHints(int hintflags) {
        if (this.pixelOrderChanges) {
            hintflags &= 0xFFFFFFFD;
        }
        this.consumer.setHints(hintflags);
    }

    public void imageComplete(int status) {
        if (status != 2) {
            this.producer.removeConsumer(this);
        }
        super.imageComplete(status);
    }

    public static int filterStream(InputStream in, OutputStream out, ImageFilterPlus filter) {
        PpmDecoder producer = new PpmDecoder(in);
        filter.setSource(producer);
        try {
            PpmEncoder consumer = new PpmEncoder(new FilteredImageSource(producer, filter), out);
            consumer.encode();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            return 1;
        }
        return 0;
    }
}

