/*
 * Decompiled with CFR 0.152.
 */
package Acme.Nnrpd;

import Acme.Nnrpd.NewsDbException;
import Acme.Utils;
import java.util.Hashtable;

public class NewsDbArticle {
    private long dbStamp;
    private String text;
    private int headLen;
    private int bodyStart;
    private Hashtable headers = new Hashtable();

    public NewsDbArticle(long dbStamp, String text) throws NewsDbException {
        this.dbStamp = dbStamp;
        this.text = text;
        int lflf = text.indexOf("\n\n");
        if (lflf != -1) {
            this.headLen = lflf + 1;
            this.bodyStart = lflf + 2;
            return;
        }
        throw new NewsDbException("can't find end of header");
    }

    protected long getDbStamp() {
        return this.dbStamp;
    }

    public String getText() {
        return this.text;
    }

    public int getHeadLen() {
        return this.headLen;
    }

    public int getBodyStart() {
        return this.bodyStart;
    }

    public String getHeader(String name) {
        String val = (String)this.headers.get(name);
        if (val == null) {
            val = NewsDbArticle.getHeader(this.text, name);
            if (val == null) {
                return null;
            }
            this.headers.put(name, val);
        }
        return val;
    }

    public static String getHeader(String text, String name) {
        boolean bol = true;
        int nameLen = name.length();
        int textLen = text.length();
        if (name.charAt(nameLen - 1) != ':') {
            name = String.valueOf(name) + ":";
            ++nameLen;
        }
        char[] nameChars = name.toLowerCase().toCharArray();
        int nameIdx = 0;
        int textIdx = 0;
        while (textIdx < textLen) {
            char ch = Character.toLowerCase(text.charAt(textIdx));
            if (ch == '\n') {
                if (bol) break;
                bol = true;
                nameIdx = 0;
            } else if (nameIdx != 0 || bol) {
                bol = false;
                if (ch == nameChars[nameIdx]) {
                    if (++nameIdx >= nameLen) {
                        int startIdx = ++textIdx + Utils.strSpan(text, " \t", textIdx);
                        int endIdx = text.indexOf(10, startIdx);
                        return text.substring(startIdx, endIdx);
                    }
                } else {
                    nameIdx = 0;
                }
            }
            ++textIdx;
        }
        return null;
    }
}

