/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import Acme.LruHashtable;
import Acme.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NoRobots {
    private static final String robotFile = "/robots.txt";
    private String robotName;
    private Hashtable servers = new LruHashtable(500);

    public NoRobots(String robotName) {
        this.robotName = robotName;
    }

    public boolean ok(URL url) {
        String protocol = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        String file = url.getFile();
        Vector disallows = this.getDisallows(protocol, host, port);
        Enumeration en = disallows.elements();
        while (en.hasMoreElements()) {
            String pattern = (String)en.nextElement();
            if (!file.startsWith(pattern)) continue;
            return false;
        }
        return true;
    }

    private Vector getDisallows(String protocol, String host, int port) {
        String key = String.valueOf(protocol) + "://" + host + ":" + port;
        Vector<String> disallows = (Vector<String>)this.servers.get(key);
        if (disallows != null) {
            return disallows;
        }
        disallows = new Vector<String>();
        try {
            URL robotUrl = new URL(protocol, host, port, robotFile);
            try {
                String line;
                BufferedReader robotReader = new BufferedReader(new InputStreamReader(robotUrl.openStream()));
                boolean userAgentIsMe = false;
                while ((line = robotReader.readLine()) != null) {
                    String value;
                    if ((line = line.trim()).startsWith("#")) continue;
                    int cmt = line.indexOf(35);
                    if (cmt != -1) {
                        line = line.substring(0, cmt).trim();
                    }
                    if (line.length() == 0) {
                        userAgentIsMe = false;
                        continue;
                    }
                    if (line.toLowerCase().startsWith("user-agent:")) {
                        if (userAgentIsMe || !Utils.match(value = line.substring(11).trim(), this.robotName)) continue;
                        userAgentIsMe = true;
                        continue;
                    }
                    if (!line.toLowerCase().startsWith("disallow:") || !userAgentIsMe) continue;
                    value = line.substring(9).trim();
                    disallows.addElement(value);
                }
            }
            catch (IOException iOException) {
            }
        }
        catch (MalformedURLException malformedURLException) {}
        this.servers.put(key, disallows);
        return disallows;
    }
}

