/*
 * Decompiled with CFR 0.152.
 */
package Acme;

import java.applet.AudioClip;
import java.io.IOException;
import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class SynthAudioClip
implements AudioClip {
    private static final long SAMPLES_PER_SEC = 8000L;
    AudioData data;
    InputStream stream;
    private static final int[] expLut = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    private static final int CLIP = 32635;
    private static final int BIAS = 132;

    public SynthAudioClip(int hz, long millis, double amplitude) {
        int samples = (int)(millis * 8000L / 1000L);
        byte[] buf = new byte[samples];
        int i = 0;
        while (i < buf.length) {
            buf[i] = SynthAudioClip.toUlaw((int)(amplitude * Math.sin(Math.PI * 2 * (double)i * (double)hz / 8000.0)));
            ++i;
        }
        this.data = new AudioData(buf);
    }

    public SynthAudioClip(int hz, long millis) {
        this(hz, millis, 16384.0);
    }

    private static byte toUlaw(int linear) {
        int sign;
        if (linear >= 0) {
            sign = 0;
        } else {
            sign = 128;
            linear = -linear;
        }
        if (linear > 32635) {
            linear = 32635;
        }
        int exponent = expLut[(linear += 132) >> 7 & 0xFF];
        int mantissa = linear >> exponent + 3 & 0xF;
        byte ulaw = (byte)(~(sign | exponent << 4 | mantissa));
        return ulaw;
    }

    public synchronized void play() {
        this.stop();
        if (this.data != null) {
            this.stream = new AudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
        }
    }

    public synchronized void loop() {
        this.stop();
        if (this.data != null) {
            this.stream = new ContinuousAudioDataStream(this.data);
            AudioPlayer.player.start(this.stream);
        }
    }

    public synchronized void stop() {
        if (this.stream != null) {
            AudioPlayer.player.stop(this.stream);
            try {
                this.stream.close();
            }
            catch (IOException iOException) {}
            this.stream = null;
        }
    }
}

