package org.genealogie.utils;

import java.util.*;
import java.io.*;
import org.genealogie.log.Log;

public class RessourcesUtils {

	private Hashtable ressources = new Hashtable();

	private static RessourcesUtils ru=null;

	public RessourcesUtils() {
		try {
			ResourceBundle rb=ResourceBundle.getBundle("properties.Conf");
			if( rb!=null ) {
				ressources.put("IMAGES",rb.getString("IMAGES"));
				ressources.put("IMG-SMALL",rb.getString("IMG-SMALL"));
			}
		} catch(Exception ex) {
			ex.printStackTrace();
			Log.log(ex);
		}
	}

	public static RessourcesUtils getInstance() {
		if( ru==null )
			ru=new RessourcesUtils();
		return ru;
	}

	public String getChaine(String chaine) {
		if( ressources.get(chaine)!=null )
			return (String)ressources.get(chaine);
		else
			return "";
	}
}