package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.apache.regexp.*;
import org.genealogie.log.Log;

import org.genealogie.ejbs.entites.personne.*;
import org.genealogie.ejbs.sessions.genealogie.*;
import org.genealogie.utils.*;

public final class FichePersonneAction extends CheckAction {

	private Hashtable typeActs = new Hashtable();

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	private void loadTypeActe(GenealogieBean genealogie) {
		Vector ta=genealogie.getTypesActe();
		for(int cpt=0;cpt<ta.size();cpt++) {
			TypesActeUtils tau=(TypesActeUtils)ta.elementAt(cpt);
			typeActs.put(new Integer(tau.getId()),tau.getNom());
		}
	}

	private PersonneBean filtrerPersonnes(FamillesBean famille,PersonneBean personne,Vector familles,int borneSup) {
		if( personne.getPersonnePereId()!=0 ) {
			Vector famillesIds=famille.getFamillesPersonne(personne.getPersonnePereId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				personne.setPersonnePereId(0);
		}

		if( personne.getPersonneMereId()!=0 ) {
			Vector famillesIds=famille.getFamillesPersonne(personne.getPersonneMereId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				personne.setPersonneMereId(0);
		}

		if( personne.getPersonneParrainId()!=0 ) {
			Vector famillesIds=famille.getFamillesPersonne(personne.getPersonneParrainId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				personne.setPersonneParrainId(0);
		}

		if( personne.getPersonneMarraineId()!=0 ) {
			Vector famillesIds=famille.getFamillesPersonne(personne.getPersonneMarraineId());
			boolean contient=false;
			for(int cpt=0;cpt<famillesIds.size();cpt++) {
				int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				personne.setPersonneMarraineId(0);
		}

		//Au niveau des dates
		if( borneSup>0 ) {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date tmp=sdf.parse("01/01/"+borneSup, pos);
			java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());
			if( personne.getPersonneDateNaissance()!=null ) {
				if( (personne.getPersonneDateNaissance()).compareTo(dateBorneSup)>0 ) {
					personne.setNaissanceCommunicable(false);
				}
			}
			if( personne.getPersonneDateBapteme()!=null ) {
				if( (personne.getPersonneDateBapteme()).compareTo(dateBorneSup)>0 ) {
					personne.setBaptemeCommunicable(false);
				}
			}
			if( personne.getPersonneDateDeces()!=null ) {
				if( (personne.getPersonneDateDeces()).compareTo(dateBorneSup)>0 ) {
					personne.setDecesCommunicable(false);
				}
			}
			if( personne.getPersonneDateInhumation()!=null ) {
				if( (personne.getPersonneDateInhumation()).compareTo(dateBorneSup)>0 ) {
					personne.setInhumationCommunicable(false);
				}
			}
		}

		return personne;
	}

	private Vector filtrerPersonnes(FamillesBean famille,Vector personnes,Vector familles) {
		for(int cpt=0;cpt<personnes.size();cpt++) {
			PersonneUtils pu=(PersonneUtils)personnes.elementAt(cpt);
			Vector famillesIds=famille.getFamillesPersonne(pu.getId());
			boolean contient=false;
			for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
				int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				pu.setId(0);
		}
		return personnes;
	}

	private Vector filtrerMariages(FamillesBean famille,Vector mariages,Vector familles,int borneSup) {
		for(int cpt=0;cpt<mariages.size();cpt++) {
			MariageUtils mu=(MariageUtils)mariages.elementAt(cpt);
			Vector famillesIds=famille.getFamillesPersonne(mu.getIdConjoint());
			boolean contient=false;
			for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
				int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
				if( contient(familleId,familles) ) {
					contient=true;
					break;
				}
			}
			if( !contient )
				mu.setIdConjoint(0);

			//Au niveau des dates
			if( borneSup>0 ) {
				SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
				ParsePosition pos=new ParsePosition(0);
				java.util.Date tmp=sdf.parse("01/01/"+borneSup, pos);
				java.sql.Date dateBorneSup=new java.sql.Date(tmp.getTime());
				if( mu.getDateMariage()!=null ) {
					if( (mu.getDateMariage()).compareTo(dateBorneSup)>0 ) {
						mu.setCommunicable(false);
					}
				}
			}
		}
		return mariages;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionErrors errors = new ActionErrors();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
				
			GenealogieBean genealogie=new GenealogieBean(conn);
			DocumentsBean docs=new DocumentsBean(conn);
			FamillesBean familles=new FamillesBean(conn);

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				Vector famillesIds=familles.getFamillesPersonne(id);
				boolean contient=false;
				for(int cpt=0;cpt<famillesIds.size();cpt++) {
					int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			PersonnePK pk=new PersonnePK();
			pk.personneId=id;
			PersonneBean personne=new PersonneBean(conn);
			personne.ejbFindByPrimaryKey(pk);
			personne.ejbLoad();
			if( isAccesTotal(request) )
				request.setAttribute("personne",personne);
			else {
				request.setAttribute("personne",filtrerPersonnes(familles,personne,getAuth(request).getFamilles(),getAuth(request).getBorneSup()));
			}

			String notes=personne.getPersonneCommentaires();
			if( notes!=null ) {
				Vector tokensNotes=getTokens(notes);
				request.setAttribute("notes",tokensNotes);
			} else {
				request.setAttribute("notes",new Vector());
			}

			String adresses=personne.getPersonneAdresses();
			if( adresses!=null ) {
				Vector tokensAdresses=getTokens(adresses);
				request.setAttribute("adresses",tokensAdresses);
			} else {
				request.setAttribute("adresses",new Vector());
			}

			Vector mariages=genealogie.getMariages(id,personne.getPersonneHomme());
			if( isAccesTotal(request) )
				request.setAttribute("mariages",mariages);
			else
				request.setAttribute("mariages",filtrerMariages(familles,mariages,getAuth(request).getFamilles(),getAuth(request).getBorneSup()));
			Vector enfants=genealogie.getEnfants(id);
			if( isAccesTotal(request) )
				request.setAttribute("enfants",enfants);
			else
				request.setAttribute("enfants",filtrerPersonnes(familles,enfants,getAuth(request).getFamilles()));
			Vector actes=genealogie.getListeActes(id);
			request.setAttribute("actes",filtrerActesBorneSup(actes,getAuth(request).getBorneSup()));
			Vector documents=docs.getListeDocuments(id);
			request.setAttribute("documents",documents);
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}