package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.apache.regexp.*;
import org.genealogie.log.Log;

import org.genealogie.ejbs.sessions.genealogie.*;
import org.genealogie.utils.*;

public final class FicheVilleAction extends CheckAction {

	private boolean isVilleAutorisee(CommuneDetailUtils commune,AuthUtils au) {
		Vector communes=au.getCommunes();
		Vector communesFamilles=au.getCommunesFamilles();
		Vector departements=au.getDepartements();
		Vector pays=au.getPays();

		for(int cpt=0;cpt<pays.size();cpt++) {
			int id=((Integer)pays.elementAt(cpt)).intValue();
			if( id==commune.getPaysId() )
				return true;
		}

		for(int cpt=0;cpt<departements.size();cpt++) {
			int id=((Integer)departements.elementAt(cpt)).intValue();
			if( id==commune.getDepartementId() )
				return true;
		}

		for(int cpt=0;cpt<communes.size();cpt++) {
			int id=((Integer)communes.elementAt(cpt)).intValue();
			if( id==commune.getId() )
				return true;
		}

		for(int cpt=0;cpt<communesFamilles.size();cpt++) {
			int id=((Integer)communesFamilles.elementAt(cpt)).intValue();
			if( id==commune.getId() )
				return true;
		}

		return false;
	}

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionErrors errors = new ActionErrors();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			GenealogieBean genealogie=new GenealogieBean(conn);
			CommuneDetailUtils commune=genealogie.getDetailCommune(id);
			//Envoi des infos  la jsp
			request.setAttribute("commune",commune);
			if( !isAccesTotal(request) ) {
				if( isVilleAutorisee(commune,getAuth(request)) )
					request.setAttribute("active","1");
				else
					request.setAttribute("active","0");
			} else
				request.setAttribute("active","1");
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}