package org.genealogie.consanguinite;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.io.*;
import java.text.*;
import org.genealogie.ejbs.sessions.genealogie.*;
import org.genealogie.log.Log;
import org.genealogie.utils.*;
import org.genealogie.arbre.*;
import javax.swing.*;

/**
 * Classe de calcul de consanguinit
 *
 * @author  Templier Thierry
 * @version $Revision: 1.2 $
 */
public class ConsanguiniteCalculator {

	private int id1;

	private int id2;

	private HttpServletRequest request;

	private GenealogieBean genealogie;

        /**
         * Constructeur de la tache.
         *
         * @param     splash  l'instance sur la fentre de progression ( null si la tache n'est pas lanc depuis l'ihm )
         * @param     etatTable  l'instance sur le label d'tat de la fentre de progression ( null si la tache n'est pas lanc depuis l'ihm )
         * @param     progressBar  l'instance sur la barre de progression de la fentre de progression ( null si la tache n'est pas lanc depuis l'ihm )
         */
	public ConsanguiniteCalculator(HttpServletRequest request,GenealogieBean genealogie,int id1,int id2) {
		this.id1=id1;
		this.id2=id2;
		this.request=request;
		this.genealogie=genealogie;
	}

	private PositionGraphic getIndiceReference(GraphicArbre ga,int id) {
		EltCase ec=ga.getRacine();
		if( ec.getId()==id )
			return new PositionGraphic(1,0);

		for(int cpt=2;cpt<=ga.getNbGenerations();cpt++) {
			Vector liste=ga.getGeneration(cpt);
			for(int cpt1=0;cpt1<liste.size();cpt1++) {
				EltCase elt=(EltCase)liste.elementAt(cpt1);
				if( elt!=null && elt.getId()==id )
					return new PositionGraphic(cpt,cpt1);
			}
		}

		return null;
	}

        /**
         * Enlve les accents des caractres accentus
         *
         * @param     chaine  chaine de caractres
         * @return    chaine convertie
         */
	public String convertirAccents(String chaine) {
		chaine=chaine.replace('',' ');
		chaine=chaine.replace('','a');
		chaine=chaine.replace('','a');
		chaine=chaine.replace('','a');
		chaine=chaine.replace('','e');
		chaine=chaine.replace('','e');
		chaine=chaine.replace('','e');
		chaine=chaine.replace('','e');
		chaine=chaine.replace('','c');
		chaine=chaine.replace('','i');
		chaine=chaine.replace('','i');
		chaine=chaine.replace('','o');
		chaine=chaine.replace('','o');
		chaine=chaine.replace('','u');
		chaine=chaine.replace('','u');
		chaine=chaine.replace('','u');
		return chaine;
	}

        /**
         * Excute la tache.
         */
	public void calculer() {
		ChargementArbre ca1=new ChargementArbre(id1,0,0,genealogie);
		GraphicArbre ga1=ca1.chargerGraphics();

		ChargementArbre ca2=new ChargementArbre(id2,0,0,genealogie);
		GraphicArbre ga2=ca2.chargerGraphics();

		PositionGraphic pos1=null;
		PositionGraphic pos2=null;

		boolean trouve=false;
		EltCase ec=ga1.getRacine();
		if( ec!=null ) {
			if( (pos2=getIndiceReference(ga2,ec.getId()))!=null ) {
				pos1=new PositionGraphic(1,0);
				trouve=true;
			}
		}

		for(int cpt=2;cpt<=ga1.getNbGenerations() && !trouve;cpt++) {
			Vector liste=ga1.getGeneration(cpt);
			for(int cpt1=0;cpt1<liste.size() && !trouve;cpt1++) {
				EltCase elt=(EltCase)liste.elementAt(cpt1);
				if( elt!=null ) {
					if( (pos2=getIndiceReference(ga2,elt.getId()))!=null ) {
						pos1=new PositionGraphic(cpt,cpt1);
						trouve=true;
					}
				}
			}
		}

		if( pos1!=null && pos2!=null ) {
			String droitCivil="";
			String droitCanon="";
			//Droit civil
			int degreCivil=pos1.getGeneration()-1+pos2.getGeneration()-1;
			if( degreCivil>1 )
				droitCivil=""+degreCivil+" degrs de consanguinit";
			else
				droitCivil=""+degreCivil+" degr de consanguinit";

			request.setAttribute("civil",droitCivil);

			//Droit canon
			if( pos1.getGeneration()==pos2.getGeneration() ) {
				droitCanon="parent du "+(pos1.getGeneration()-1)+"e degr de consanguinit";
			} else if( (pos1.getGeneration()-1)==0 ) {
				droitCanon="parent du "+(pos2.getGeneration()-1)+"e degr de consanguinit";
			} else if( (pos2.getGeneration()-1)==0 ) {
				droitCanon="parent du "+(pos1.getGeneration()-1)+"e degr de consanguinit";
			} else {
				droitCanon="parent du "+(pos1.getGeneration()-1)+"e au "+(pos2.getGeneration()-1)+"e degr de consanguinit";
			}

			request.setAttribute("canon",droitCanon);
			afficherConsanguinite(pos1.getGeneration(),pos1.getIndice(),ga1,pos2.getGeneration(),pos2.getIndice(),ga2);
		} else {
			request.setAttribute("civil","Aucune parent");
			request.setAttribute("canon","Aucune parent");
			afficherConsanguinite(ga1,ga2);
		}
	}

	public void afficherConsanguinite(GraphicArbre ga1,GraphicArbre ga2) {
		Vector personnes1=new Vector();
		Vector personnes2=new Vector();
		if( ga1.getRacine()!=null ) {
			EltCase ec=ga1.getRacine();
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu!=null )
				personnes1.addElement(pu);
		}
		if( ga2.getRacine()!=null ) {
			EltCase ec=ga2.getRacine();
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu!=null )
				personnes2.addElement(pu);
		}

		request.setAttribute("arborescence1",personnes1);
		request.setAttribute("arborescence2",personnes2);
	}

	public void afficherConsanguinite(int generation1,int position1,GraphicArbre ga1,int generation2,int position2,GraphicArbre ga2) {
		Vector personnes1=new Vector();
		Vector personnes2=new Vector();
		for(int cpt=generation1;cpt>1;cpt--) {
			Vector generation=(Vector)ga1.getGeneration(cpt);
			if( generation==null )
				break;
			EltCase ec=(EltCase)generation.elementAt(position1);
			if( ec==null )
				break;
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu==null )
				break;
			personnes1.addElement(pu);
			position1=position1/2;
		}
		if( ga1.getRacine()!=null ) {
			EltCase ec=ga1.getRacine();
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu!=null )
				personnes1.addElement(pu);
		}

		for(int cpt=generation2;cpt>1;cpt--) {
			Vector generation=(Vector)ga2.getGeneration(cpt);
			if( generation==null )
				break;
			EltCase ec=(EltCase)generation.elementAt(position2);
			if( ec==null )
				break;
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu==null )
				break;
			personnes2.addElement(pu);
			position2=position2/2;
		}
		if( ga2.getRacine()!=null ) {
			EltCase ec=ga2.getRacine();
			PersonneUtils pu=genealogie.getPersonne(ec.getId());
			if( pu!=null )
				personnes2.addElement(pu);
		}

		request.setAttribute("arborescence1",personnes1);
		request.setAttribute("arborescence2",personnes2);
	}
}

class PositionGraphic {

	private int generation;

	private int indice;


	public PositionGraphic(int generation,int indice) {
		this.generation=generation;
		this.indice=indice;
	}

	public int getGeneration() {
		return generation;
	}

	public int getIndice() {
		return indice;
	}

}