package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.apache.regexp.*;
import org.genealogie.log.Log;

import org.genealogie.ejbs.sessions.genealogie.*;
import org.genealogie.utils.*;

public final class ListeDocumentsTypeAction extends CheckAction {

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionErrors errors = new ActionErrors();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Type
			int type=0;
			if( request.getParameterValues("type")!=null ) {
				try {
					type=Integer.parseInt(request.getParameterValues("type")[0]);
				} catch(Exception ex) {}
			}

			if( type==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id du type de document");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				boolean contient=false;
				Vector typesDocumentsAutorises=getAuth(request).getTypesDocuments();
				for(int cpt=0;cpt<typesDocumentsAutorises.size();cpt++) {
					int idTypeDocument=((Integer)typesDocumentsAutorises.elementAt(cpt)).intValue();
					if( idTypeDocument==type ) {
						contient=true;
						break;
					}
				}

				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			DocumentsBean documents=new DocumentsBean(conn);
			TypesDocumentUtils tdu=documents.getTypeDocument(type);
			String nomTypeDocument="?";
			if( tdu!=null )
				nomTypeDocument=tdu.getNom();
			Vector resultats=documents.getListeDocumentsType(type);

			//Envoi des infos  la jsp
			request.setAttribute("type-id",String.valueOf(type));
			request.setAttribute("type-nom",nomTypeDocument);
			request.setAttribute("result",resultats);

			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
				else
					request.removeAttribute(mapping.getAttribute());
			}

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
		}
	}
}