package org.genealogie.web;

import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import java.text.*;
import org.apache.regexp.*;

public final class RechercherTablesForm extends ActionForm  {

	private String action = "Create";

	private String rechercher = null;

	private String dateDebut = null;

	private String dateFin = null;

	private String ville = null;

	private String page = null;

	private int ordre = 0;

	public String getAction() {
		return this.action;
	}

	public void setAction(String action) {
		this.action = action;
	}

	public String getRechercher() {
		return this.rechercher;
	}

	public void setRechercher(String rechercher) {
		this.rechercher = rechercher;
	}

	public String getDateDebut() {
		return this.dateDebut;
	}

	public void setDateDebut(String dateDebut) {
		this.dateDebut = dateDebut;
	}

	public String getDateFin() {
		return this.dateFin;
	}

	public void setDateFin(String dateFin) {
		this.dateFin = dateFin;
	}

	public String getVille() {
		return this.ville;
	}

	public void setVille(String ville) {
		this.ville = ville;
	}

	public String getPage() {
		return this.page;
	}

	public void setPage(String page) {
		this.page = page;
	}

	public int getOrdre() {
		return this.ordre;
	}

	public void setOrdre(int ordre) {
		this.ordre = ordre;
	}

	public void reset(ActionMapping mapping, HttpServletRequest request) {
		this.action = "Create";
		this.rechercher=null;
		this.dateDebut=null;
		this.dateFin=null;
		this.ville=null;
		this.page=null;
	}

	public boolean isNull() {
		if( rechercher==null && dateDebut==null && dateFin==null && ville==null && page==null )
			return true;
		return false;
	}

	private boolean isDateValide(String chaineDate) {
		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				return true;
			if( moisAnnee.match(chaineDate) )
				return true;
			if( jourMoisAnnee.match(chaineDate) )
				return true;
		} catch(Exception ex) {
		}
		return false;
	}

	public ActionErrors validate(ActionMapping mapping,HttpServletRequest request) {
		ActionErrors errors = new ActionErrors();

		if( isNull() )
			return errors;

		if( dateDebut!=null && !dateDebut.equals("") && !isDateValide(dateDebut) )
	            errors.add("dateDebut",new ActionError("error.date.format"));

		if( dateFin!=null && !dateFin.equals("") && !isDateValide(dateFin) )
	            errors.add("dateFin",new ActionError("error.date.format"));

		return errors;
	}
}
