package org.genealogie.log;

import java.io.*;
import java.util.*;
import java.text.*;

public class Log {
	private static String remplace(String chaine,String motif,String remplacer) {
		StringBuffer newChaine=new StringBuffer();
		int indice=0;
		while( (indice=chaine.indexOf(motif))!=-1 ) {
			newChaine.append(chaine.substring(0,indice));
			newChaine.append(remplacer);
			chaine=chaine.substring(indice+motif.length());
		}
		newChaine.append(chaine);
		return newChaine.toString();
	}
	
	public static String getStackHtml(Exception ex) {
		String msg=getStack(ex);
		return remplace(msg,"\n","<br>");
	}

	public static String getStack(Exception ex) {
		try {
			StringWriter sw=new StringWriter();
			PrintWriter pw=new PrintWriter(sw);
			ex.printStackTrace(pw);
			String msg=sw.toString();
			pw.close();
			return msg;
		} catch(Exception ex1) {
			return "";
		}
	}

	public static void log(Exception ex) {
		try {
			StringWriter sw=new StringWriter();
			PrintWriter pw=new PrintWriter(sw);
			ex.printStackTrace(pw);
			String msg=sw.toString();
			pw.close();

			SimpleDateFormat sdf=new SimpleDateFormat("yyyyMMdd");
			String now=sdf.format( new java.util.Date() );

			FileWriter fw=new FileWriter("jgenea."+now+".log",true);
			fw.write( "### "+(new java.util.Date()).toString()+" ##############################################\n");
			fw.write(msg+"\n");
			fw.flush();
			fw.close();
		} catch(Exception ex1) {
			System.out.println("Probleme d'ecriture dans les logs: "+ex1.toString());
		}
	}

	public static void log(String msg) {
		try {
			SimpleDateFormat sdf=new SimpleDateFormat("yyyyMMdd");
			String now=sdf.format( new java.util.Date() );

			FileWriter fw=new FileWriter("jgenea."+now+".log",true);
			fw.write( "\n### "+(new java.util.Date()).toString()+" ########################################\n");
			fw.write(msg+"\n");
			fw.flush();
			fw.close();
		} catch(Exception ex1) {
			System.out.println("Probleme d'ecriture dans les logs: "+ex1.toString());
		}
	}

	public static void trace(String msg) {
		try {
			SimpleDateFormat sdf=new SimpleDateFormat("yyyyMMdd");
			String now=sdf.format( new java.util.Date() );

			FileWriter fw=new FileWriter("jgenea."+now+".trace",true);
			//fw.write( "\n### "+(new java.util.Date()).toString()+" ########################################\n");
			fw.write(msg+"\n");
			fw.flush();
			fw.close();
		} catch(Exception ex1) {
			System.out.println("Probleme d'ecriture dans les logs: "+ex1.toString());
		}
	}

	public static void main(String[] args) {
		try {
			throw new IOException("Un test");
		} catch(Exception ex) {
			log(ex);
		}
	}
}