package org.genealogie.utils;

import java.sql.Date;
import java.io.Serializable;
import java.text.*;

public class MariageUtils implements Serializable {

	private Date dateMariage;

	private String dateMariageApp;

	private String lieuMariage;

	private int idConjoint;

	private String nomConjoint;

	private String prenomConjoint;

	private boolean communicable;


	public MariageUtils(int idConjoint,String nomConjoint,String prenomConjoint,Date dateMariage,String dateMariageApp,String lieuMariage) {
		this.idConjoint=idConjoint;
		this.dateMariage=dateMariage;
		this.dateMariageApp=dateMariageApp;
		this.lieuMariage=lieuMariage;
		this.nomConjoint=nomConjoint;
		this.prenomConjoint=prenomConjoint;
		this.communicable=true;
	}

	public int getIdConjoint() {
		return idConjoint;
	}

	public void setIdConjoint(int idConjoint) {
		this.idConjoint = idConjoint;
	}

	public String getNomConjoint() {
		return nomConjoint;
	}

	public String getPrenomConjoint() {
		return prenomConjoint;
	}

	public Date getDateMariage() {
		return dateMariage;
	}

	public void setDateMariage(Date dateMariage) {
		this.dateMariage = dateMariage;
	}


	public String getDateString() {
		SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
		if( dateMariage!=null )
			return sdf.format( dateMariage );
		return "";
	}

	public String getDateMariageApp() {
		return dateMariageApp;
	}

	public void setDateMariageApp(String dateMariageApp) {
		this.dateMariageApp = dateMariageApp;
	}

	public String getLieuMariage() {
		return lieuMariage;
	}

	public void setLieuMariage(String lieuMariage) {
		this.lieuMariage = lieuMariage;
	}

	public void setCommunicable(boolean communicable) {
		this.communicable = communicable;
	}

	public String getMariage() {
		StringBuffer chaine=new StringBuffer();

		if( !communicable )
			return "( date & lieu non communicables )";

		String d=getDateString();
		String d1=getDateMariageApp();
		if( d!=null && !d.equals("") )
			chaine.append("le "+d);
		else if( d1!=null && !d1.equals("") )
			chaine.append(d1);

		String l=getLieuMariage();
		if( l!=null && !l.equals("") )
			chaine.append("  "+l);

		return chaine.toString();
	}
}