package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.genealogie.log.Log;

import org.genealogie.arbre.*;
import org.genealogie.utils.*;
import org.genealogie.ejbs.sessions.genealogie.*;

public final class ArbreAscendantPersonneAction extends CheckAction {

	private Vector filtrerGeneration(Vector generation,int borneSup) {
		if( borneSup==0 )
			return generation;

		for(int cpt=0;cpt<generation.size();cpt++) {
			EltCase ec=(EltCase)generation.elementAt(cpt);
			if( ec==null )
				continue;
			ec=filtrerEltCase(ec,borneSup);
		}
		return generation;
	}

	private EltCase filtrerEltCase(EltCase ec,int borneSup) {
		if( borneSup==0 )
			return ec;

		String chrono=ec.getChronologie();
		int indice=0;
		if( (indice=chrono.indexOf("-"))!=-1 ) {
			String tmp=(chrono.substring(0,indice)).trim();
			String tmp1=(chrono.substring(indice+1)).trim();
			int naissance=0;
			int deces=0;
			if( !tmp.equals("?") ) {
				try {
				naissance=Integer.parseInt(tmp);
				} catch(Exception ex) {}
			}
			if( !tmp1.equals("?") ) {
				try {
					deces=Integer.parseInt(tmp1);
				} catch(Exception ex) {}
			}
			StringBuffer newChrono=new StringBuffer();
			if( naissance!=0 ) {
				if( naissance>borneSup )
					newChrono.append("NC - ");
				else
					newChrono.append(naissance+" - ");
			} else
				newChrono.append("? - ");
			if( deces!=0 ) {
				if( deces>borneSup )
					newChrono.append("NC");
				else
					newChrono.append(deces);
			} else
				newChrono.append("?");
			ec.setChronologie(newChrono.toString());
		}
		return ec;
	}

	private GraphicArbre filtrerArbre(FamillesBean famille,GraphicArbre ga,Vector familles) {
		Vector generation2=ga.getGeneration(2);
		Vector generation3=ga.getGeneration(3);
		Vector generation4=ga.getGeneration(4);

		if( generation2!=null ) {
			for(int cpt=0;cpt<generation2.size();cpt++) {
				EltCase pu=(EltCase)generation2.elementAt(cpt);
				if( pu!=null ) {
					Vector famillesIds=famille.getFamillesPersonne(pu.getId());
					boolean contient=false;
					for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
						int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
						if( contient(familleId,familles) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						if( generation3!=null )
							generation3.setElementAt(null,2*cpt);
						if( generation4!=null ) {
							generation4.setElementAt(null,(2*cpt)*2);
							generation4.setElementAt(null,(2*cpt)*2+1);
						}

						if( generation3!=null )
							generation3.setElementAt(null,2*cpt+1);
						if( generation4!=null ) {
							generation4.setElementAt(null,(2*cpt+1)*2);
							generation4.setElementAt(null,(2*cpt+1)*2+1);
						}

						pu.setId(0);
					}
				}
			}
		}

		if( generation3!=null ) {
			for(int cpt=0;cpt<generation3.size();cpt++) {
				EltCase pu=(EltCase)generation3.elementAt(cpt);
				if( pu!=null ) {
					Vector famillesIds=famille.getFamillesPersonne(pu.getId());
					boolean contient=false;
					for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
						int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
						if( contient(familleId,familles) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						if( generation4!=null ) {
							generation4.setElementAt(null,2*cpt);
							generation4.setElementAt(null,2*cpt+1);
						}

						pu.setId(0);
					}
				}
			}
		}

		if( generation4!=null ) {
			for(int cpt=0;cpt<generation4.size();cpt++) {
				EltCase pu=(EltCase)generation4.elementAt(cpt);
				if( pu!=null ) {
					Vector famillesIds=famille.getFamillesPersonne(pu.getId());
					boolean contient=false;
					for(int cpt1=0;cpt1<famillesIds.size();cpt1++) {
						int familleId=((Integer)famillesIds.elementAt(cpt1)).intValue();
						if( contient(familleId,familles) ) {
							contient=true;
							break;
						}
					}
					if( !contient ) {
						pu.setId(0);
					}
				}
			}
		}

		return ga;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionErrors errors = new ActionErrors();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Id
			int id=0;
			if( request.getParameterValues("id")!=null ) {
				try {
					id=Integer.parseInt(request.getParameterValues("id")[0]);
				} catch(Exception ex) {}
			}

			if( id==0 ) {
				request.setAttribute("exception","Erreur: impossible de rcuperer l'id");
				request.setAttribute("stack","");
				setNoCache(response);
				return (mapping.findForward("exception"));
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();

			GenealogieBean genealogie=new GenealogieBean(conn);
			FamillesBean familles=new FamillesBean(conn);

			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				Vector famillesIds=familles.getFamillesPersonne(id);
				boolean contient=false;
				for(int cpt=0;cpt<famillesIds.size();cpt++) {
					int familleId=((Integer)famillesIds.elementAt(cpt)).intValue();
					if( contient(familleId,getAuth(request).getFamilles()) ) {
						contient=true;
						break;
					}
				}
				if( !contient ) {
					setNoCache(response);
					return (mapping.findForward("accueil"));
				}
			}

			PersonneUtils base=genealogie.getPersonne(id);
			ChargementArbre ca=new ChargementArbre(id,0,0,genealogie);
			GraphicArbre ga=ca.chargerGraphics(4);

			if( !isAccesTotal(request) )
				ga=filtrerArbre(familles,ga,getAuth(request).getFamilles());

			request.setAttribute("generation1",filtrerEltCase(ga.getRacine(),getAuth(request).getBorneSup()));
			request.setAttribute("generation2",filtrerGeneration(ga.getGeneration(2),getAuth(request).getBorneSup()));
			request.setAttribute("generation3",filtrerGeneration(ga.getGeneration(3),getAuth(request).getBorneSup()));
			request.setAttribute("generation4",filtrerGeneration(ga.getGeneration(4),getAuth(request).getBorneSup()));

			/*request.setAttribute("generation1",ga.getRacine());
			request.setAttribute("generation2",ga.getGeneration(2));
			request.setAttribute("generation3",ga.getGeneration(3));
			request.setAttribute("generation4",ga.getGeneration(4));*/
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}