package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.apache.regexp.*;
import org.genealogie.log.Log;

import org.genealogie.ejbs.sessions.genealogie.*;
import org.genealogie.utils.*;

public final class LoginAction extends Action {

	private Vector listeBases = null;

	private Vector listeBasesDescriptifs = null;

	private void setNoCache(HttpServletResponse response) {
		response.setHeader("Cache-Control", "no-cache");
		response.setHeader("Pragma", "no-cache");
		response.setHeader("Expires", "0");
	}

	private void chargerRessources() {
		try {
			ResourceBundle rb=ResourceBundle.getBundle("properties.Db");
			if( rb!=null ) {
				String liste=rb.getString("bases");
				String descs=rb.getString("bases-desc");
				StringTokenizer stListe=new StringTokenizer(liste,",");
				StringTokenizer stDescs=new StringTokenizer(descs,",");
				listeBases=new Vector();
				while( stListe.hasMoreTokens() ) {
					listeBases.addElement(stListe.nextToken());
				}
				listeBasesDescriptifs=new Vector();
				while( stDescs.hasMoreTokens() ) {
					listeBasesDescriptifs.addElement(stDescs.nextToken());
				}
			}
		} catch(Exception ex) {
			ex.printStackTrace();
			Log.log(ex);
		}
	}

	public ActionForward execute(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		try {
			String login="";
			String password="";
			String pool="";
			if( request.getParameterValues("login")!=null )
				login=request.getParameterValues("login")[0];
			if( request.getParameterValues("password")!=null )
				password=request.getParameterValues("password")[0];
			if( request.getParameterValues("pool")!=null )
				pool=request.getParameterValues("pool")[0];

			if( pool.equals("") ) {
				chargerRessources();
				request.setAttribute("bases",listeBases);
				request.setAttribute("descriptifs",listeBasesDescriptifs);
				request.setAttribute("login",login);
				request.setAttribute("password",password);
				request.setAttribute("message","");

				HttpSession session = request.getSession();
				// Remove the obsolete form bean
				if (mapping.getAttribute() != null) {
					if ("session".equals(mapping.getScope()))
						session.removeAttribute(mapping.getAttribute());
					else
						request.removeAttribute(mapping.getAttribute());
				}
				setNoCache(response);
				return (mapping.findForward("success"));
			} else {
				javax.sql.DataSource dataSource=null;
				java.sql.Connection conn=null;
				try {
					/*for(Enumeration e=servlet.getServletContext().getAttributeNames();e.hasMoreElements();) {
						String cle=(String)e.nextElement();
						System.out.println("cle "+cle);
					}*/
					dataSource = getDataSource(request,pool);
					DatabaseUtils.setIdPool(pool);
					conn = dataSource.getConnection();
					AuthentificationBean auth=new AuthentificationBean(conn);
					GenealogieBean genealogie=new GenealogieBean(conn);
					AuthUtils au=null;
					if( (au=auth.authentifier(login,password))!=null ) {
						Vector communesFamilles=genealogie.getListeCommunesFamille(au.getFamilles(),au.getBorneSup());
						au.setCommunesFamilles(communesFamilles);
						HttpSession session = request.getSession();
						session.setAttribute("auth",au);
						setNoCache(response);
						return (mapping.findForward("accueil"));
					} else {
						chargerRessources();
						request.setAttribute("bases",listeBases);
						request.setAttribute("descriptifs",listeBasesDescriptifs);
						request.setAttribute("login",login);
						request.setAttribute("password",password);
						request.setAttribute("message","Erreur d'authentification");

						HttpSession session = request.getSession();
						// Remove the obsolete form bean
						if (mapping.getAttribute() != null) {
							if ("session".equals(mapping.getScope()))
								session.removeAttribute(mapping.getAttribute());
							else
								request.removeAttribute(mapping.getAttribute());
						}

						setNoCache(response);
						return (mapping.findForward("success"));
					}

				} catch (SQLException ex) {
					request.setAttribute("exception",(ex.getClass()).getName());
					request.setAttribute("stack",Log.getStackHtml(ex));
					setNoCache(response);
					return (mapping.findForward("exception"));
				} finally {
					try { if( conn!=null ) conn.close(); } catch (SQLException e) { getServlet().log("Connection.close", e); }
				}
			}
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		}
	}
}