package org.genealogie.web;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import java.sql.*;
import javax.sql.*;
import java.util.*;
import java.net.*;
import java.text.*;
import org.apache.regexp.*;
import org.genealogie.log.Log;

import org.genealogie.ejbs.sessions.genealogie.*;

public final class RechercherVillesActesAction extends CheckAction {
	private int NB_PAR_PAGES=20;

	public java.sql.Date getDate(String chaineDate) {
		java.sql.Date cDate=null;

		if( chaineDate==null || chaineDate.equals("") )
			return null;

		try {
			RE annee = new RE("^(\\d{4})$");
			RE moisAnnee = new RE("^(\\d{2}\\d{4})$");
			RE jourMoisAnnee = new RE("^(\\d{2}\\d{2}\\d{4})$");

			if( annee.match(chaineDate) )
				chaineDate="01/01/"+chaineDate;
			if( moisAnnee.match(chaineDate) )
				chaineDate="01/"+chaineDate;

			SimpleDateFormat sdf=new SimpleDateFormat("dd/MM/yyyy");
			ParsePosition pos=new ParsePosition(0);
			java.util.Date d=sdf.parse(chaineDate,pos);
			cDate=new java.sql.Date(d.getTime());

		} catch(Exception ex) {
		}
		return cDate;
	}

	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			// Report any errors we have discovered back to the original form
			ActionErrors errors = new ActionErrors();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			//Page
			int page=0;
			if( ((RechercherVillesActesForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherVillesActesForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			GenealogieBean genealogie=new GenealogieBean(conn);
			Vector villes=null;
			int nbActes=0;
			//Vrifier les droits d'accs
			if( !isAccesTotal(request) ) {
				villes=genealogie.getListeCommunesActes(getAuth(request));
				nbActes=genealogie.getNombreActes(getAuth(request));
			} else {
				villes=genealogie.getListeCommunesActes();
				nbActes=genealogie.getNombreActes();
			}
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<villes.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(villes.elementAt(cpt));
			}

			int debut=0;
			int fin=villes.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (villes.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((villes.size()/NB_PAR_PAGES)) )
				if( (villes.size()/NB_PAR_PAGES)-20>=0 )
					debut=(villes.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("nb_actes",String.valueOf(nbActes));
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( villes.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",String.valueOf(villes.size()));

			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
				else
					request.removeAttribute(mapping.getAttribute());
			}

			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
		}
	}
}