package org.genealogie.web;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Vector;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.genealogie.log.Log;
import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.utils.URLEncodingScheme;

public final class RechercherVillesAction extends CheckAction {
	public ActionForward performTask(ActionMapping mapping,ActionForm form,HttpServletRequest request,
				 HttpServletResponse response) throws IOException, ServletException {
		javax.sql.DataSource dataSource=null;
		java.sql.Connection conn=null;

		try {
			if( ((RechercherVillesForm)form).isNull() ) {
				setNoCache(response);
				return (mapping.findForward("failure"));
			}

			// Report any errors we have discovered back to the original form
			ActionMessages errors = new ActionMessages();
			if (!errors.isEmpty()) {
				saveErrors(request, errors);
				setNoCache(response);
				return (new ActionForward(mapping.getInput()));
			}

			StringBuffer chaineRecherche=new StringBuffer();
			String separateur="";
			//Chaine de recherche
			if( ((RechercherVillesForm)form).getRechercher()!=null ) {
				chaineRecherche.append(separateur+"rechercher=");
				chaineRecherche.append(URLEncoder.encode(((RechercherVillesForm)form).getRechercher(),URLEncodingScheme.SCHEME));
				separateur="&";
			}
			if( ((RechercherVillesForm)form).getDepartement()!=null ) {
				chaineRecherche.append(separateur+"departement=");
				chaineRecherche.append(URLEncoder.encode(((RechercherVillesForm)form).getDepartement(),URLEncodingScheme.SCHEME));
				separateur="&";
			}

			//Page
			int page=0;
			if( ((RechercherVillesForm)form).getPage()!=null ) {
				try {
					page=Integer.parseInt(((RechercherVillesForm)form).getPage())-1;
					if( page<0 )
						page=0;
				} catch(Exception ex) {}
			}

			if( getIdPool().equals("") ) {
				setNoCache(response);
				return (mapping.findForward("login"));
			}

			dataSource = getDataSource(request,getIdPool());
			conn = dataSource.getConnection();
			GenealogieDAO genealogie=new GenealogieDAO(conn);
			String nom=((RechercherVillesForm)form).getRechercher();
			if( nom!=null ) {
				nom=nom.trim();
				if( nom.equals("") )
					nom=null;
			}
			String departement=((RechercherVillesForm)form).getDepartement();
			if( departement!=null ) {
				departement=departement.trim();
				if( departement.equals("") )
					departement=null;
			}
			Vector villes=null;
			if( nom!=null && departement==null )
				villes=genealogie.getListeCommunes(nom.toUpperCase());
			else if( nom!=null && departement!=null )
				villes=genealogie.getListeCommunes(nom.toUpperCase(),departement.toUpperCase());
			else if( nom==null && departement!=null )
				villes=genealogie.getListeCommunesDepartement(departement.toUpperCase());
			Vector resultats=new Vector();
			for(int cpt=page*NB_PAR_PAGES;cpt<villes.size() && cpt<(page*NB_PAR_PAGES+NB_PAR_PAGES);cpt++) {
				resultats.addElement(villes.elementAt(cpt));
			}

			int debut=0;
			int fin=villes.size()/NB_PAR_PAGES;
			if( page-10>=0 )
				debut=page-10;
			if( page+10<=fin )
				fin=page+10;
			if( debut==0 )
				if( (villes.size()/NB_PAR_PAGES)>=20 )
					fin=20;
			if( fin==((villes.size()/NB_PAR_PAGES)) )
				if( (villes.size()/NB_PAR_PAGES)-20>=0 )
					debut=(villes.size()/NB_PAR_PAGES)-20;

			//Envoi des infos  la jsp
			request.setAttribute("result",resultats);
			request.setAttribute("page_debut",new Integer(debut+1));
			if( villes.size()%NB_PAR_PAGES==0 )
				request.setAttribute("page_fin",new Integer(fin));
			else
				request.setAttribute("page_fin",new Integer(fin+1));
			request.setAttribute("page",new Integer(page+1));
			request.setAttribute("nombre",new Integer(villes.size()));
			if( nom!=null && departement!=null )
				request.setAttribute("recherche",nom+" dans le dpartement "+departement);
			else if( nom==null && departement!=null )
				request.setAttribute("recherche","dpartement "+departement);
			else if( nom!=null && departement==null )
				request.setAttribute("recherche",nom);
			request.setAttribute("urlRecherche",chaineRecherche.toString());
		
			setNoCache(response);
			return (mapping.findForward("success"));
		} catch(Exception ex) {
			request.setAttribute("exception",(ex.getClass()).getName());
			request.setAttribute("stack",Log.getStackHtml(ex));
			setNoCache(response);
			return (mapping.findForward("exception"));
		} finally {
			try {
				if( conn!=null )
					conn.close();
			} catch (SQLException e) { getServlet().log("Connection.close", e); }
			HttpSession session = request.getSession();
			// Remove the obsolete form bean
			if (mapping.getAttribute() != null) {
				if ("session".equals(mapping.getScope()))
					session.removeAttribute(mapping.getAttribute());
			}
		}
	}
}
