package org.genealogie.metier.dao.tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Vector;

import junit.framework.TestCase;

import org.genealogie.metier.dao.GenealogieDAO;
import org.genealogie.metier.modele.Recherche;

public class TestGenealogieDAO extends TestCase {
	
	private Connection conn;
	private GenealogieDAO dao;
	private Vector filtre;

	protected void setUp() throws Exception {
		Class.forName("org.hsqldb.jdbcDriver");
		conn = DriverManager.getConnection("jdbc:hsqldb:C:\\Eclipse\\workspace\\jgenea-refactoring\\db\\jgenea","sa","");
		dao = new GenealogieDAO(conn);
		filtre = new Vector(1);
		filtre.add(new Integer(1));
	}

	protected void tearDown() throws Exception {
		conn.close();
	}
	

	public void testGetResultatsRecherche() {
		Recherche criteres = new Recherche("dupond","yvonne",false,false,false,false,false,"trebeurden","01/01/1716","01/01/1716");
		Vector resultatSansFiltre = dao.getResultatsRecherche(criteres);
		Vector resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yves",false,false,false,false,false,"trebeurden","01/01/1716","01/01/1716");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yvonne",true,true,true,true,true,"trebeurden","01/01/1716","01/01/1716");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("0 personne attendue",0,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("0 personne attendue",0,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yves",true,true,true,true,true,"trebeurden","01/01/1716","01/01/1716");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("0 personne attendue",0,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("0 personne attendue",0,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yvonne",true,true,false,true,true,"trebeurden","01/01/1716","01/01/1716");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("0 personne attendue",0,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("0 personne attendue",0,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yves",true,true,false,true,true,"trebeurden","01/01/1716","01/01/1716");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("0 personne attendue",0,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("0 personne attendue",0,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yvonne",true,true,false,true,true,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("dupond","",true,true,false,true,true,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("2 personnes attendues",2,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("2 personnes attendues",2,resultatFiltre.size());
		
		criteres = new Recherche("","yvonne",true,true,false,true,true,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("","",true,true,false,true,true,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("11 personnes attendues",11,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("2 personnes attendues",2,resultatFiltre.size());
		
		criteres = new Recherche("dupond","yvonne",false,false,true,false,false,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("dupond","",false,false,true,false,false,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("2 personnes attendues",2,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("","yvonne",false,false,true,false,false,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("1 personne attendue",1,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("1 personne attendue",1,resultatFiltre.size());
		
		criteres = new Recherche("","",false,false,true,false,false,"","","");
		resultatSansFiltre = dao.getResultatsRecherche(criteres);
		resultatFiltre = dao.getResultatsRecherche(criteres,filtre);
		assertNotNull("Le rsultat ne peut tre null",resultatSansFiltre);
		assertEquals("10 personnes attendues",10,resultatSansFiltre.size());
		assertNotNull("Le rsultat ne peut tre null",resultatFiltre);
		assertEquals("2 personnes attendues",2,resultatFiltre.size());
	}
}
