<?xml version = "1.0" encoding = "ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="iso-8859-1"  standalone="yes"  indent="no" />
  <xsl:template match="/">
     <xsl:apply-templates  />
  </xsl:template>
  <xsl:template match="page">
      <html>
         <head>
            <title>PilotWeb : le site des pilotes privs</title>
            <link rel="stylesheet" type="text/css" href="/style.css"></link>
         </head>
         <script>
		  function vacopen(url) {
		    open(url,'vac','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,width=660,height=600');
			return ;
		  }
		 </script>
         <body>
           
         	<table border="0" width="600" cellspacing="0" cellpadding="0">
         	<tr><td><img border="0" src="/img/piloteweb00.png"/> </td><td><img border="0" src="/img/piloteweb10.png"/></td></tr>
         	<tr><td><xsl:apply-templates select="connexion" /><xsl:apply-templates select="deconnexion" /></td><td class="shortcuts" valign="middle" border="0" background="/img/piloteweb11.png">
			<xsl:apply-templates select="raccourcis/*" />
			</td></tr>
         	</table>
         	<br/>
         	<table width="600">
         	  <tr>
         	    <td>
                   <xsl:apply-templates select="principal" />
                </td>
              </tr>
            </table>
         
         </body>
      </html>
   </xsl:template>
   
   <xsl:template match="connexion">
       <a href="/connexion.php"><img border="0" src="/img/piloteweb01.png"/></a>
   </xsl:template>
     <xsl:template match="deconnexion">
       <a alt="Me dconnecter" href="/deconnexion.php"><img alt="Me dconnecter" border="0" src="/img/piloteweb01b.png"/></a>
   </xsl:template>
   <xsl:template match="raccourcis/a">
   		<xsl:element name="a">
			
			<xsl:attribute name="href"><xsl:value-of select="@href" /></xsl:attribute>
			<xsl:value-of select="." />
		</xsl:element>
		<xsl:if test = "position() != last()">
			|
		</xsl:if>
   </xsl:template>

   <xsl:template match="principal">
        <div class="titre">
               <xsl:value-of select="@titre" />
        </div>
        <hr/>
   		<xsl:apply-templates />
   		<hr/>
   		&#169; 2002, Stphane Mariel.
   </xsl:template>
   <xsl:template match="formulaire">
      <xsl:element name="form">
         <xsl:attribute name="ENCTYPE">multipart/form-data</xsl:attribute>
         <xsl:attribute name="action"><xsl:value-of select="@action" /></xsl:attribute>
         <xsl:attribute name="method"><xsl:value-of select="@method" /></xsl:attribute>
         <center>
         <table>
            <xsl:apply-templates select="child::*" />
            <tr><td colspan="2" align="center" class="titre">
            	<input type="submit" value="Valider" name="submit" />
            </td></tr>
         </table>
         </center>
      </xsl:element>
   </xsl:template>
   <xsl:template match="p">
      <xsl:copy-of select="."/>
   </xsl:template>

   <xsl:template match="position">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][degres]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">40</xsl:with-param>

               <xsl:with-param name="stop">50</xsl:with-param>
            </xsl:call-template>
         </xsl:element>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][minutes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>'
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][secondes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>" / 
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][degres]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">-10</xsl:with-param>

               <xsl:with-param name="stop">10</xsl:with-param>
            </xsl:call-template>
         </xsl:element>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][minutes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>'
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][secondes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>"
         </td>
      </tr>
   </xsl:template>

   <xsl:template name="degre">
      <xsl:param name="start" />

      <xsl:param name="stop" />

      <xsl:if test="$start &lt; $stop">
         <option>
            <xsl:value-of select="$start" />
         </option>
	     <xsl:if test="$start = -1">
		    <option>-0</option>
		 </xsl:if>
         <xsl:call-template name="degre">
            <xsl:with-param name="start">
               <xsl:value-of select="$start + 1" />
            </xsl:with-param>

            <xsl:with-param name="stop">
               <xsl:value-of select="$stop" />
            </xsl:with-param>
         </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:template match="texte">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>
         <td>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:attribute name="type">text</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
      <xsl:template match="textelong">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>
         <td>
            <xsl:element name="textarea">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="passe">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>

               <xsl:attribute name="type">password</xsl:attribute>
               <xsl:attribute name="width">100%</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   
   <xsl:template match="choix">
      <tr>
        <td> </td>
        <td class="reponse">
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:attribute name="type">checkbox</xsl:attribute>
               <xsl:attribute name="style">{ border-width: 0px; }</xsl:attribute>
            </xsl:element>
            <xsl:value-of select="@titre" />
        </td>
      </tr>
   </xsl:template>
   <xsl:template match="fichier">
     <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <input type="hidden" name="MAX_FILE_SIZE " value="100000"/>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>

               <xsl:attribute name="type">file</xsl:attribute>
               <xsl:attribute name="width">100%</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="option">
      <xsl:copy-of select="." />
   </xsl:template>
   <xsl:template match="liste">
    <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <xsl:element name="select">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:apply-templates />
            </xsl:element>
         </td>
     </tr>
   </xsl:template>
   <xsl:template match="aerodrome/aerodrome">
     <table width="100%" bgcolor="#b6e4fb" cellpadding="0" cellspacing="0" border="0">
	   <tr>
	     <td width="1%" background="/img/ciblebg.png"><img src="/img/cibleae.png" /></td>
		 <td><xsl:value-of select="@nom"/></td>
		 <td align="right">
		   <xsl:element name="a">
		    <xsl:attribute name="target">detail</xsl:attribute>
		    <xsl:attribute name="href">resultat.php?aerodrome=<xsl:value-of select="@id"/></xsl:attribute>
			dtail
	       </xsl:element>
		 </td>
	   </tr>
     </table>
   </xsl:template>
   <xsl:template match="aerodrome">
   <table bgcolor="#d9eff9" cellpadding="0" cellspacing="0" border="0">
     <xsl:if test = "position() != 1">
	    <tr bgcolor="#b6e4fb">
		   <xsl:if test = "parent::aerodromes"><td background="/img/ciblebg.png">&#160;</td></xsl:if>
		   <td colspan="3">&#160;</td>
		</tr>
	 </xsl:if>
     <tr>
	   <xsl:if test = "parent::aerodromes">
	   <xsl:element name="td">
	     <xsl:attribute name="rowspan">4</xsl:attribute>
		 <xsl:attribute name="background">/img/ciblebg.png</xsl:attribute>
		 <xsl:attribute name="valign"><xsl:choose>
		   <xsl:when test="position() = 1">top</xsl:when>
		   <xsl:when test="position() = last()">bottom</xsl:when>
		 </xsl:choose></xsl:attribute>
		 <img src="/img/cible.png" />
	   </xsl:element>
	   </xsl:if>
	   <td nowrap="true">
	      <h3><xsl:value-of select="@nom" /></h3>
	   </td><td align="right">
	      Lat : <xsl:value-of select="@x" /> /
		  Lon : <xsl:value-of select="@y" /> 
	   </td>
	 </tr>
	 <tr>
	   <td>
	      (<xsl:value-of select="@code" />)
	   </td>
	   <td></td>
	 </tr>
	 <tr>
	   <td valign="top">
	    <xsl:choose>
	     <xsl:when test="boolean(@photo)">
		  <xsl:element name="a">
		   <xsl:attribute name="href">
		   javascript:vacopen('<xsl:value-of select="@photo"/>')
		   </xsl:attribute>
		   <xsl:element name="img">
		     <xsl:attribute name="width">200</xsl:attribute>
			 <xsl:attribute name="border">0</xsl:attribute>
		     <xsl:attribute name="src"><xsl:value-of select="@photo"/></xsl:attribute>
		   </xsl:element>
		  </xsl:element>
	     </xsl:when>
		 <xsl:otherwise>
		   <p>pas de carte disponible.</p>
		 </xsl:otherwise>
		</xsl:choose>
	   </td>
	   <td valign="top">
	     <xsl:apply-templates select="child::*[not(self::aerodrome)]"/>
	   </td>
	 </tr>
   </table>
   <xsl:apply-templates select="child::*[self::aerodrome]"/>
   </xsl:template>
   <xsl:template match="meteo">
     <h3>Donnes mto :</h3><div class="meteo">
     <xsl:copy-of select="." />  </div>
   </xsl:template>
   <xsl:template match="partenaire">
     <center>
	 <b>- publicit -</b>
     <table bgcolor="white" style="border-color: red; border-style: solid; border-width: 1px;">
	   <tr>
	   <xsl:if test="string-length(@photo)">
	     <td>
	       <xsl:element name="img">
		     <xsl:attribute name="src"><xsl:value-of select="@photo"/></xsl:attribute>
		   </xsl:element>
	     </td>
		</xsl:if>
		 <td>
		   <div><xsl:value-of select="@nom" /></div>
		   <xsl:apply-templates />
		 </td>
	   </tr>
	 </table>
	 </center>
   </xsl:template>
   <xsl:template match="adresse">
     <pre>
	   <xsl:value-of select="." />
	 </pre>
   </xsl:template>
   
   <xsl:template match="pilotes">
     <div>
	 <h3>Pilotes sur zone :</h3>
	   <table>
	     <xsl:apply-templates />
	   </table>
	 </div>
   </xsl:template>
   <xsl:template match="pilote">
     <tr>
	   <td>
	     <xsl:if test="boolean(@photo)">
		   <xsl:element name="img">
		     <xsl:attribute name="src"><xsl:value-of select="@photo"/></xsl:attribute>
		   </xsl:element>
	     </xsl:if>
	   </td><td nowrap="true">
	   <xsl:value-of select="@nom" />
	   (
	     <xsl:element name="a">
		    <xsl:attribute name="href">mailto:<xsl:value-of select="@email"/></xsl:attribute>
			<xsl:value-of select="@email" />
		 </xsl:element>
	   )
	   </td>
	 </tr>
   </xsl:template>
   
   <xsl:template match="repere">
     <table bgcolor="#d9eff9" width="100%" cellpadding="0" cellspacing="0" border="0">
     <tr bgcolor="#b6e4fb">
	   <td width="1%"  background="/img/ciblebg.png" valign="middle">&#160;</td>
	   <td colspan="2">&#160;</td>
	 </tr><tr>
	 <td width="1%"  background="/img/ciblebg.png" valign="middle"><img src="/img/cible.png" /></td>
	   <td nowrap="true"><xsl:value-of select="@nom"/></td><td align="right">Lat : <xsl:value-of select="@x" /> / Lon : <xsl:value-of select="@y" /></td>
	 </tr>
	 </table>
   </xsl:template>
</xsl:stylesheet>

