<?php xml version = "1.0" encoding = "ISO-8859-1" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:svg="http://www.w3.org/2000/svg">
  <xsl:output method="html" encoding="iso-8859-1"  standalone="yes"  indent="no" />
  <xsl:template match="/">
     <xsl:apply-templates select="page" />
  </xsl:template>
  <xsl:template match="page">
      <html xmlns="http://www.w3.org/1999/xhtml" xmlns:svg="http://www.w3.org/2000/svg">
         <head>
            <title>PilotWeb : le site des pilotes privs</title>
            <link rel="stylesheet" type="text/css" href="/style.css"></link>
         </head>

         <body>

         	<table border="0" width="600" cellspacing="0" cellpadding="0">
         	<tr><td><img border="0" src="/img/piloteweb00.png"/> </td><td><img border="0" src="/img/piloteweb10.png"/></td></tr>
         	<tr><td><xsl:apply-templates select="connexion" /><xsl:apply-templates select="deconnexion" /></td><td class="shortcuts" valign="middle" border="0" background="/img/piloteweb11.png">
			<xsl:apply-templates select="raccourcis/*" />
			</td></tr>
         	</table>
         	<br/>
			
         	<table width="600">
         	  <tr>
         	    <td>
				<xsl:apply-templates select="principal" />
				
                </td>
              </tr>
            </table>
         
         </body>
      </html>
   </xsl:template>
   
   <xsl:template match="connexion">
       <a href="/connexion.php"><img border="0" src="/img/piloteweb01.png"/></a>
   </xsl:template>
     <xsl:template match="deconnexion">
       <a alt="Me dconnecter" href="/deconnexion.php"><img alt="Me dconnecter" border="0" src="/img/piloteweb01b.png"/></a>
   </xsl:template>
   <xsl:template match="raccourcis/a">
   		<xsl:element name="a">
			
			<xsl:attribute name="href"><xsl:value-of select="@href" /></xsl:attribute>
			<xsl:value-of select="." />
		</xsl:element>
		<xsl:if test = "position() != last()">
			|
		</xsl:if>
   </xsl:template>

   <xsl:template match="principal">
        <div class="titre">
               <xsl:value-of select="@titre" />
        </div>
        <hr/>
				<xsl:apply-templates />
   		<hr/>
   		&#169; 2002, Stphane Mariel.
   </xsl:template>
   <xsl:template match="formulaire">
      <xsl:element name="form">
         <xsl:attribute name="ENCTYPE">multipart/form-data</xsl:attribute>
         <xsl:attribute name="action"><xsl:value-of select="@action" /></xsl:attribute>
         <xsl:attribute name="method"><xsl:value-of select="@method" /></xsl:attribute>
         <center>
         <table>
            <xsl:apply-templates select="child::*" />
            <tr><td colspan="2" align="center" class="titre">
            	<input type="submit" value="Valider" name="submit" />
            </td></tr>
         </table>
         </center>
      </xsl:element>
   </xsl:template>
   <xsl:template match="p">
      <xsl:copy-of select="."/>
   </xsl:template>

   <xsl:template match="position">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][degres]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">40</xsl:with-param>

               <xsl:with-param name="stop">50</xsl:with-param>
            </xsl:call-template>
         </xsl:element>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][minutes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>'
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[x][secondes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>" / 
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][degres]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">-10</xsl:with-param>

               <xsl:with-param name="stop">10</xsl:with-param>
            </xsl:call-template>
         </xsl:element>
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][minutes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>'
         <xsl:element name="select">
            <xsl:attribute name="name">
               <xsl:value-of select="@nom" />[y][secondes]
            </xsl:attribute>
            <xsl:call-template name="degre">
               <xsl:with-param name="start">0</xsl:with-param>

               <xsl:with-param name="stop">60</xsl:with-param>
            </xsl:call-template>
         </xsl:element>"
         </td>
      </tr>
   </xsl:template>

   <xsl:template name="degre">
      <xsl:param name="start" />

      <xsl:param name="stop" />

      <xsl:if test="$start &lt; $stop">
         <option>
            <xsl:value-of select="$start" />
         </option>

         <xsl:call-template name="degre">
            <xsl:with-param name="start">
               <xsl:value-of select="$start + 1" />
            </xsl:with-param>

            <xsl:with-param name="stop">
               <xsl:value-of select="$stop" />
            </xsl:with-param>
         </xsl:call-template>
      </xsl:if>
   </xsl:template>

   <xsl:template match="texte">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>
         <td>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:attribute name="type">text</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
      <xsl:template match="textelong">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>
         <td>
            <xsl:element name="textarea">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="passe">
      <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>

               <xsl:attribute name="type">password</xsl:attribute>
               <xsl:attribute name="width">100%</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   
   <xsl:template match="choix">
      <tr>
        <td> </td>
        <td class="reponse">
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:attribute name="type">checkbox</xsl:attribute>
               <xsl:attribute name="style">{ border-width: 0px; }</xsl:attribute>
            </xsl:element>
            <xsl:value-of select="@titre" />
        </td>
      </tr>
   </xsl:template>
   <xsl:template match="fichier">
     <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <input type="hidden" name="MAX_FILE_SIZE " value="100000"/>
            <xsl:element name="input">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>

               <xsl:attribute name="type">file</xsl:attribute>
               <xsl:attribute name="width">100%</xsl:attribute>
            </xsl:element>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match="option">
      <xsl:copy-of select="." />
   </xsl:template>
   <xsl:template match="liste">
    <tr>
         <td class="question">
            <xsl:value-of select="@titre" />
         </td>

         <td>
            <xsl:element name="select">
               <xsl:attribute name="name">
                  <xsl:value-of select="@nom" />
               </xsl:attribute>
               <xsl:apply-templates />
            </xsl:element>
         </td>
     </tr>
   </xsl:template>

   <xsl:template match="aerodromes">
     <svg:svg width="600" height="600">
	    <svg:text x="0" y="585" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">46 &#176;</svg:text>
	    <svg:line x1="0" y1="590" x2="599" y2="590" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="0" y="285" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">47 &#176;</svg:text>
	    <svg:line x1="0" y1="290" x2="599" y2="290" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:line x1="300" y1="0" x2="300" y2="595" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="305" y="20" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">0 &#176;</svg:text>

		<svg:line x1="400" y1="0" x2="400" y2="595" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="405" y="20" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">-1 &#176;</svg:text>
		<svg:line x1="500" y1="0" x2="500" y2="595" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="505" y="20" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">-2 &#176;</svg:text>

		<svg:line x1="200" y1="0" x2="200" y2="595" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="205" y="20" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">1 &#176;</svg:text>
		<svg:line x1="100" y1="0" x2="100" y2="595" style="fill:none;stroke:rgb(0,0,0);stroke-width:1" />
		<svg:text x="105" y="20" style="fill:rgb(0,0,0);font-family:Arial;font-size:12">2 &#176;</svg:text>
		
	   	<xsl:apply-templates />
	 </svg:svg>
   </xsl:template>
   <xsl:template match="aerodrome/aerodrome">
      <xsl:element name="svg:ellipse">
	    <xsl:attribute name="cx"><xsl:value-of select="round(300+100 * (substring-before(@y, &quot;&#176;&quot;) + 
(number(substring-before(@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="cy"><xsl:value-of select="round(590 - 300 * (substring-before(@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
	    <xsl:attribute name="rx">4</xsl:attribute>
	    <xsl:attribute name="ry">4</xsl:attribute>
	    <xsl:attribute name="style">fill:rgb(0,0,255);stroke:rgb(0,0,0);stroke-width:1</xsl:attribute>
	  </xsl:element> 
	  <xsl:element name="svg:text">
	    <xsl:attribute name="x"><xsl:value-of select="round(310+100 * (substring-before(@y, &quot;&#176;&quot;) + 
(number(substring-before(@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="y"><xsl:value-of select="round(595 - 300 * (substring-before(@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="style">fill:rgb(0,0,0);font-family:Arial;font-size:12</xsl:attribute>
		<xsl:value-of select="@nom" />  
	  </xsl:element>
   </xsl:template>
   <xsl:template match="aerodrome|repere">
      <xsl:element name="svg:ellipse">
	    <xsl:attribute name="cx"><xsl:value-of select="round(300+100 * (substring-before(@y, &quot;&#176;&quot;) + 
(number(substring-before(@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="cy"><xsl:value-of select="round(590 - 300 * (substring-before(@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
	    <xsl:attribute name="rx">4</xsl:attribute>
	    <xsl:attribute name="ry">4</xsl:attribute>
	    <xsl:attribute name="style">fill:rgb(255,0,0);stroke:rgb(0,0,0);stroke-width:1</xsl:attribute>
	  </xsl:element> 
	  <xsl:element name="svg:text">
	    <xsl:attribute name="x"><xsl:value-of select="round(310+100 * (substring-before(@y, &quot;&#176;&quot;) + 
(number(substring-before(@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="y"><xsl:value-of select="round(595 - 300 * (substring-before(@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="style">fill:rgb(0,0,0);font-family:Arial;font-size:12</xsl:attribute>
		<xsl:value-of select="@nom" />  
	  </xsl:element>
      <xsl:if test="position() != last()">
	     <xsl:element name="svg:line">
	    <xsl:attribute name="x1"><xsl:value-of select="round(300+100 * (substring-before(@y, &quot;&#176;&quot;) + 
(number(substring-before(@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="y1"><xsl:value-of select="round(590 - 300 * (substring-before(@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
        </xsl:attribute>
	    <xsl:attribute name="x2"><xsl:value-of select="round(300+100 * (substring-before(following-sibling::*[position() = 1]/@y, &quot;&#176;&quot;) + 
(number(substring-before(following-sibling::*[position() = 1]/@y, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(following-sibling::*[position() = 1]/@y, &quot;&#176;&quot;)&lt;0))*
((substring-after(substring-before(following-sibling::*[position() = 1]/@y,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(following-sibling::*[position() = 1]/@y,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
		</xsl:attribute>
		<xsl:attribute name="y2"><xsl:value-of select="round(590 - 300 * (substring-before(following-sibling::*[position() = 1]/@x, &quot;&#176;&quot;) -47 + 
(number(substring-before(following-sibling::*[position() = 1]/@x, &quot;&#176;&quot;)&gt;0) - 
number(substring-before(following-sibling::*[position() = 1]/@x, &quot;&#176;&quot;)&lt;0)) *
((substring-after(substring-before(following-sibling::*[position() = 1]/@x,'&quot;'),&quot;'&quot;) div 3600) +
(substring-before(substring-after(following-sibling::*[position() = 1]/@x,&quot;&#176;&quot;),&quot;'&quot;) div 60))))" />
        </xsl:attribute>
<xsl:attribute name="style">fill:none;stroke:rgb(0,255,0);stroke-width:1</xsl:attribute>
		 </xsl:element>
	  </xsl:if>
	  <xsl:apply-templates />
   </xsl:template>
   
</xsl:stylesheet>

