VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Compte"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit
Implements ObjectControl
Private oObjectContext As ObjectContext
Private vSql As Variant

Private Sub ObjectControl_Activate()
    Set oObjectContext = GetObjectContext
End Sub

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
End Sub


Public Function Transfer(strDB As Variant, srcCpt As Variant, destCpt As Variant, montant As Variant) As Boolean
    On Error GoTo ErreurTransfert
    Set oObjectContext = GetObjectContext()
    Transfer = False
    
    If Not DebitCompte(CStr(strDB), CStr(srcCpt), CCur(montant)) Then
        oObjectContext.SetAbort
        Exit Function
    End If
    
    If Not CreditCompte(CStr(strDB), CStr(destCpt), CCur(montant)) Then
        oObjectContext.SetAbort
        Exit Function
    End If

    oObjectContext.SetComplete
    Transfer = True
    Exit Function
ErreurTransfert:
    oObjectContext("Response").Write "La transaction a t abandonne : <BR><I>" & Err.Number & Err.Description & "</I>"
    oObjectContext.SetAbort
End Function

Private Function ValideBalance(bal As Currency) As Boolean
    If bal < 0 Then
        ValideBalance = False
    Else
        ValideBalance = True
    End If
End Function

Private Function CreditCompte(strDB As String, CptNum As String, montant As Currency) As Boolean
    Dim oRs As ADODB.Recordset
    Dim vSql As String
    Dim cCurBalance As Currency
    
    CreditCompte = False
        
    If Not ChangeBalance(strDB, CptNum, montant) Then
      Exit Function
    Else
      Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
      vSql = "SELECT SoldApOperation FROM Enregistrement WHERE IDCompte = '" & CptNum & "' ORDER BY IDSeq DESC;"
      oRs.Open vSql, strDB
      If oRs.EOF Then
        oObjectContext("Response").Write "Un problme indtermin est intervenu dans votre composant. " & _
                                         "Operation annule"
        oObjectContext.SetAbort
        Exit Function
      Else
        cCurBalance = CCur(oRs("SoldApOperation"))
        If Not ValideBalance(cCurBalance) Then
          oObjectContext("Response").Write "Pas assez de fond " & CptNum & " - Operation annule"
          oObjectContext.SetAbort
          Exit Function
        End If
      End If
      oRs.Close
      Set oRs = Nothing
    End If
    
    CreditCompte = True
End Function

Private Function DebitCompte(strDB As String, CptNum As String, montant As Currency) As Boolean
    Dim oRs As ADODB.Recordset
    Dim vSql As String
    Dim cCurBalance As Currency
    
    DebitCompte = False
        
    If Not ChangeBalance(strDB, CptNum, -montant) Then
      Exit Function
    Else
      Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
      vSql = "SELECT SoldApOperation FROM Enregistrement WHERE IDCompte = '" & CptNum & "' ORDER BY IDSeq DESC;"
      oRs.Open vSql, strDB
      If oRs.EOF Then
        oObjectContext("Response").Write "Un problme indtermin est intervenu dans votre composant. " & _
                                         "Operation annule"
        oObjectContext.SetAbort
        Exit Function
      Else
        cCurBalance = CCur(oRs("SoldApOperation"))
        If Not ValideBalance(cCurBalance) Then
          oObjectContext("Response").Write "Pas Assez de fond " & CptNum & " - Operation annulle"
          oObjectContext.SetAbort
          Exit Function
        End If
      End If
      oRs.Close
      Set oRs = Nothing
    End If
    
    DebitCompte = True
End Function

Private Function CompteValide(db As ADODB.Connection, CptNum As String) As Boolean
    Dim oRs As ADODB.Recordset
    
    vSql = "SELECT IDCompte FROM Compte WHERE IDCompte = '" & CptNum & "';"
    Set oRs = db.Execute(vSql)
    If oRs.EOF Then
        CompteValide = False
    Else
        CompteValide = True
    End If
    oRs.Close

End Function

Private Function ChangeBalance(strDB As String, CptNum As String, montant As Currency) As Boolean
    Dim oDb As ADODB.Connection
    Dim oRs As ADODB.Recordset
    Dim cBalance As Currency
    Dim sTransType As String
    Dim sTransNote As String
    
    cBalance = False
    
    On Error GoTo InterceptErreur
    
    Set oObjectContext = GetObjectContext()
    Set oDb = oObjectContext.CreateInstance("ADODB.Connection")
    oDb.Open strDB
        
    If Not CompteValide(oDb, CptNum) Then
      oObjectContext.SetAbort
      oObjectContext("Response").Write "Le transfert a chou<BR>"
      oDb.Close
      Set oDb = Nothing
      Exit Function
    End If
    
    vSql = "SELECT SoldApOperation FROM Enregistrement WHERE IDCompte = '" & CptNum & "' ORDER BY IDSeq DESC;"

    Set oRs = oDb.Execute(vSql)
    If Not oRs.EOF Then
      cBalance = CCur(oRs("SoldApOperation"))
    End If
      
    If montant < 0 Then
      sTransType = "W"
      sTransNote = "Argent dbit"
    Else
      sTransType = "D"
      sTransNote = "Argent credit"
    End If
    oRs.Close
    
    
    vSql = "INSERT INTO Enregistrement " & _
                 "(IDCompte, NumVerif, Transdate, TransType, TransNote, " & _
                 "  montant, SoldAvOperation, SoldApOperation) " & _
           "VALUES ('" & CptNum & "', 0 ,'" & Date & "','" & _
                        sTransType & "', '" & sTransNote & "', " & CCur(montant) & "," & cBalance & "," & _
                        (cBalance + CCur(montant)) & ");"
    oDb.Execute (vSql)
    
    ChangeBalance = True
    oObjectContext.SetComplete
    
    oDb.Close
    Set oDb = Nothing
    Set oRs = Nothing
    Exit Function
    
InterceptErreur:
    Err.Raise vbObjectError + 1001, "Mouvement Solde", Err.Description
    oObjectContext.SetAbort
End Function


