<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=iso-8859-1" />
    <title>Panier</title>
    <style type="text/css">
    button {
      width: 12ex;
      height: 2em;
      margin: 0ex 1ex 0ex 1ex;
    }
    #panier {
      text-align: center;
      font-size:120%;
      background: #FAF0F5;
    }
    #user {
      padding: 1ex;
      white-space: nowrap;
    }
    </style>
    <script type="text/javascript">
// La requete HTTP
var requete;

function identifier() {
  requete = getRequete();
  if (requete != null) {
    // Constituer le corps de la requete (la chaine de requete)
    var login = document.getElementById("login").value;
    var motPasse = document.getElementById("motPasse").value;
    var corps = "login=" + encodeURIComponent(login)
      + "&motPasse=" + encodeURIComponent(motPasse);
    try {
      // Ouvrir une connexion asynchrone
      requete.open("POST", "identifier.php", true);
      // Positionner une en-tete indispensable 
      // quand les parametres sont passes par POST
      requete.setRequestHeader("Content-type", 
        "application/x-www-form-urlencoded");
      // Traitement a effectuer quand l'etat de la requete changera
      requete.onreadystatechange = onIdentifier;
      // Lancer la requete
      requete.send(corps);
      // Montrer que la requete est en cours
      montrerActivite();
    }
    catch (exc) {
      montrerInactivite();
    }
  }
  else {
    setMessage("Impossible de se connecter au serveur");
  }
}

// Ce qui s'executera lorsque la reponse arrivera
function onIdentifier() {
  if (requete.readyState == 4 && requete.status == 200) {
    // Montrer que la requete est terminee
    montrerInactivite();
    // Afficher le message de reponse recu
    setMessage(requete.responseText);
  }
}

// Abandonner la requete
function abandonnerIdentifier() {
  if (requete != null) {
    requete.abort();
  }
  montrerInactivite();
  setMessage("Requ&ecirc;te abandonn&eacute;e");
}

// Recuperer la requete existante ou une nouvelle si elle vaut null
function getRequete() {
  var result = requete;
  if (result == null) {
    if (window.XMLHttpRequest) {
      // Navigateur compatible Mozilla
      result = new XMLHttpRequest();
    }
    else if (window.ActiveXObject) {
      // Internet Explorer sous Windows
      result = new ActiveXObject("Microsoft.XMLHTTP");
    }
  }
  return result;
}

// Mettre les boutons dans l'etat initial
function montrerInactivite() {
  document.getElementById("identifierOff").style.display = "inline";
  document.getElementById("identifierOn").style.display = "none";
  document.getElementById("boutonAbandonnerIdentifier").disabled = true;
}

// Montrer que la requete est en cours
function montrerActivite() {
  document.getElementById("identifierOff").style.display = "none";
  document.getElementById("identifierOn").style.display = "inline";
  document.getElementById("boutonAbandonnerIdentifier").disabled = false;
  setMessage("");
}

// Afficher un message
function setMessage(msg) {
  document.getElementById("message").innerHTML = msg;
}
    </script>
  </head>
  
  <body onload="montrerInactivite()">
  
    <p id="panier">Zone affichant le panier</p>
    
    <form action="javascript:identifier()">
      <!--
      <fieldset id="user">
        <legend>Utilisateur</legend>
      -->
      <table border="0" cellspacing="0" cellpadding="2">
        <tbody>
          <tr>
            <td>Identifiant</td>
            <td><input type="text" id="login"/></td>
          </tr>
          <tr>
            <td>Mot de passe</td>
            <td><input type="password" id="motPasse"/></td>
          </tr>
          <tr>
            <td colspan="2" style="text-align: center">
              <button type="submit">
                <span id="identifierOff">S'identifier</span>
                <img id="identifierOn" src="loading.gif" 
                  alt="Identification en cours ..."/>
              </button>
              <button type="button" id="boutonAbandonnerIdentifier"
                onclick="abandonnerIdentifier()">Annuler</button>
            </td>
          </tr>
        </tbody>
      </table>
      <div id="message"></div>
      <!--
      </fieldset>
      -->
    </form>
  </body>
</html>
