<?php
// Concatener les stations de metro dans une string en les separant par ";"
$stations = file_get_contents("stations-metro.txt");
$stations = str_replace("\n", ";", $stations);

header("Content-type: text/javascript");
// Creer le javascript definissant l'objet Metro
print <<<END
var Metro = {
  /** Liste des stations, en 1 tableau */
  stations: ("$stations").split(";"),
  
  /** Tableau de stations dont le nom commence par debut
   *  Si debut est une chaine de blancs, renvoie un tableau vide
   *  Si maxLinesNumber est specifie, renvoie au plus 
   *  ce nombre de lignes
   */
  getStations: function(debut, maxLinesNumber) {
    var i, nom;
    var result = [];
    var lengthMax = Metro.stations.length;
    if (maxLinesNumber) {
      lengthMax = Math.min(lengthMax, maxLinesNumber);
    }
    // Si on a du contenu, pas que du blanc
    if (!debut.match(/^ *$/)) {
      for (i=0 ; i<Metro.stations.length 
          && result.length < lengthMax ; i++) {
        nom = Metro.stations[i].toLowerCase();
        if (nom.indexOf(debut.toLowerCase()) == 0) {
          result.push(Metro.stations[i]);
        }
      }
    }
    return result;
  }
};
END;
?>