/** @class
 * Mise  jour d'une liste droulante par des appels Ajax
 * @param idSelect id de la liste droulante @type String
 * @param getOptionsUrl url de l'action serveur donnant les
 * options correspondant  une valeur passeen paramtre
 * @type String
 * @param idMsg id de l'lment HTML devant recevoir les
 * messages (transfert en cours, erreurs) @type String
 */
function SelectUpdater(idSelect, getOptionsUrl, idMsg) {
  /** Liste droulante  mettre  jour @type HTMLSelectElement */
  this.select = document.getElementById(idSelect);
  // Vrifier que leid est ok
  if (!this.select) {
    Log.error("Erreur sur new SelectUpdater('" + idSelect
      + " ' ...) : " + idSelect + " introuvable");
  }
  /** Url de la requte XMLHttpRequest mettant  jour @type String */
  this.url = getOptionsUrl;
  /** Requte XMLHttpRequest de mise  jour @type XMLHttpRequest */
  this.request = null;
  /** Message si aucune option n'est trouve 
   * (dfaut : "Valeur inconnue") @type String
   */
  this.NOT_FOUND_MSG = "Valeur inconnue";
  /** Elment HTML montrant le message @type HTMLElement*/
  this.msg = document.getElementById(idMsg);
  if (!this.msg) {
    Log.error("Erreur sur new SelectUpdater(..., ..., '"
      + idMsg + "') : " + idMsg + " introuvable");
  }
}

SelectUpdater.prototype = {
  /** Lancer la requte
   * @param value valeur passe  la requte @type String
   */
  run: function(value) {
    if (this.request) {
      try {
        this.request.abort();
      }
      catch (exc) {}
    }
    try {
      this.request = new XMLHttpRequest();
      var url = this.url + encodeURIComponent(value);
      this.request.open("GET", url, true);
      this.show();
      var current = this;
      this.request.onreadystatechange = function() {
        try {
          if (current.request.readyState == 4) {
            if (current.request.status == 200) {
              current.onload();
            }
            else {
              current.msg.innerHTML = "Erreur HTTP " 
                + current.request.status + " sur '" 
                + current.url + "'";
            }
          }
        }
        catch (exc) {}
      }
      this.request.send("");
    }
    catch (exc) {
      Log.debug(exc);
    }
  },
  
  /** Mettre  jour la liste  la rception de la rponse */
  onload: function() {
    this.select.innerHTML = "";
    this.hide();
    if (this.request.responseText.length != 0) {
      // Le resultat n'est pas vide
      var options = this.request.responseText.split(";");
      var item, option;
      for (var i=0 ; i<options.length ; i++) {
        item = options[i].split("="); // value = text
        option = document.createElement("option");
        option.setAttribute("value", item[0]);
        option.innerHTML = item[1];
        this.select.appendChild(option);
      }
    }
    else {
      this.msg.innerHTML = "<span style='color: red'>"
        + this.NOT_FOUND_MSG + "</span>";
    }
  },
  
  /** Montrer que l'appel est en cours */
  show: function() {
    this.msg.innerHTML = "<em>En chargement ...</em>";
  },
  
  /** Effacer le message */
  hide: function() {
    this.msg.innerHTML = "";
  },
  
  /** Effacer la liste et le message, et annuler l'appel ventuel */
  reset: function() {
    this.select.innerHTML = "";
    this.msg.innerHTML = "";
    try {
      if (this.request) {
        this.request.abort();
      }
    }
    catch (exc) {
      Log.debug(exc);
    }
  }
}
