<?php
/**
Renvoie une liste de communes dont le nom commence par le nom passe dans 
le parametre "search",  trie par ordre alphabetique croissant.
Le nombre est limite par le parametre "size" (10 par defaut).
On recupere le nom seulement.
*/
sleep(1);
if (count($_REQUEST) == 0 || !array_key_exists("search", $_REQUEST)) {
  print "Usage : $_SERVER[PHP_SELF]?search=un-nom";
}
else {
  if (array_key_exists("size", $_REQUEST) 
      && is_numeric($_REQUEST["size"])) {
    $size = intval($_REQUEST["size"]);
  }
  else {
    $size = 10;
  }
  $nom = mb_convert_encoding($_REQUEST["search"], 
    "CP1252", "UTF-8");
  $communes = get_communes($nom, $size);
  $dansUnJour = 0;//60*60*24;
  header("Cache-Control: max-age=$dansUnJour");
  header("Content-type: text/plain; charset=windows-1252");
  $result = implode("\n", $communes);
  print $result;
  //print mb_convert_encoding($result, "UTF-8", "CP1252");
}


/** 
Tableau des noms de commune commencant par $debutNom.
*/
function get_communes($debutNom, $size) {
  // Enlever les eventuels l' le la les qui dans la BD sont apres le nom
  $debutNom = preg_replace("/L('|e |a |es )/i", "", $debutNom);
  // Transformer les blancs en - car c'est ainsi dans la BD
  $debutNom = str_replace(" ", "-", $debutNom);
  // Construire la requete
  $sql = "
    SELECT DISTINCT nom_commune
    FROM commune 
    WHERE LOWER(nom_commune) LIKE '$debutNom%'
    ORDER BY nom_commune ASC
    LIMIT 0, $size
    ";
  // Se connecter a la base
  include_once("database.php");
  $connect = get_db_connection();
  // Recuperer les enregistrements
  $lignes = mysql_query($sql)
    or die("Requete \"$query\" invalide\n".mysql_error());
  // Construire le resultat
  $result = array();
  while($row = mysql_fetch_array($lignes)){
    $result[] = $row["nom_commune"];
  }
  mysql_close();
  return $result;
}
?>