<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
  <head>
    <title>Mise  jour Ajax d'une liste droulante</title>
    <style>
    label {
      float: left;
      padding-right: 1ex;
      width: 13ex;
    }
    </style>
    <meta http-equiv="Content-type" content="iso-8859-1"/>
    <script src="util.js"></script>
    <script src="SelectUpdater.js"></script>
  </head>
  <body>
    <h1>Mise  jour Ajax d'une liste droulante</h1>
    <p>Ici, nous tentons de mettre  jour la liste en remplaant
    purement et simplement son innerHTML. Cela ne fonctionne pas
    dans IE.</p>
    <!-- description 
		<p>Quand l'utilisateur saisit le code postal, la liste 
    droulante des communes est renseigne automatiquement : le 
    nom apparat, et le code commune est indiqu au navigateur.
    <br/>L'appel au serveur se fait uniquement lorsque 
    l'utilisateur a saisi les 5 caractres du code postal, 
    pour limiter les aller-retours au strict ncessaire.
    </p>-->
    <form>
      <label>Code postal : </label>
      <input name="cp" id="cp" type="text" size="5" maxlength="5"/>
      <span id="msg_cp"></span>
      <br/>
      <label>Commune :</label>
      <select id="commune" name="no_commune">
      </select>
      <br/>
      <input type="submit" value="Enregistrer"/>
    </form>
    <script type="text/javascript">    
function updateCommune() {
  var request = new XMLHttpRequest();
  request.open("GET", 
    "serveur/get-villes-par-cp.php?output=html&cp=" 
    + document.getElementById("cp").value, true);
  request.onreadystatechange = function() {
    if (request.readyState == 4 && request.status == 200) {
      document.getElementById("commune").innerHTML = 
        request.responseText;
    }
  }
  request.send("");
}
    
window.onload = function() {
  ancienCp = "";
  document.getElementById("cp").onkeyup = function() {
    var cp = document.getElementById("cp").value;
    if (cp.length == 5) {
      if (cp != ancienCp) {
        // Faire l'appel Ajax
        updateCommune();
        ancienCp = cp;
      }
    }
    else {
      // Remettre la liste a vide et annuler l'appel eventuel
      ancienCp = "";
    }
  }
  
  document.getElementById("cp").focus();
}
    </script>
  </body>
</html>
