<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">

<html>
  <head>
    <title>Mise  jour Ajax d'une liste droulante</title>
    <style>
    label {
      float: left;
      padding-right: 1ex;
      width: 13ex;
    }
    </style>
    <meta http-equiv="Content-type" content="iso-8859-1"/>
    <script src="util.js"></script>
    <script src="json.js"></script>
    <script src="SelectUpdater.js"></script>
  </head>
  <body>
    <h1>Mise  jour Ajax d'une liste droulante</h1>
    <!-- description 
		<p>Quand l'utilisateur saisit le code postal, la liste 
    droulante des communes est renseigne automatiquement : le 
    nom apparat, et le code commune est indiqu au navigateur.
    <br/>L'appel au serveur se fait uniquement lorsque 
    l'utilisateur a saisi les 5 caractres du code postal, 
    pour limiter les aller-retours au strict ncessaire.
    </p>-->
    <form>
      <label>Code postal : </label>
      <input name="cp" id="cp" type="text" size="5" maxlength="5"/>
      <br/>
      <label>Commune :</label>
      <select name="no_commune" id="commune">
      </select>
      <span id="msg_cp"></span>
      <br/>
      <input type="submit" value="Enregistrer"/>
    </form>
    <div id="msg"></div>
    <script type="text/javascript">        
window.onload = function() {
  communeUpdater = new SelectUpdater("commune", 
    "serveur/get-villes-par-cp.php?output=json&cp=", "msg_cp");
  ancienCp = "";
  document.getElementById("cp").onkeyup = function() {
    var cp = document.getElementById("cp").value;
    if (cp.length == 5) {
      if (cp != ancienCp) {
        // Faire l'appel Ajax
        communeUpdater.run(cp);
        ancienCp = cp;
      }
    }
    else {
      // Remettre la liste a vide et annuler l'appel eventuel
      communeUpdater.reset();
      ancienCp = "";
    }
  }
}
    </script>
  </body>
</html>
