<html>
  <head>
    <link rel="stylesheet" type="text/css" href="RSSAvecXSLT.css"/>
    <script type="text/javascript" src="util.js"></script>
    <script type="text/javascript" src="XSLView.js"></script>
    <title>Afficher des flux RSS avec XSLT</title>
  </head>
  <body>
    <h1>Afficher des flux RSS avec XSLT</h1>
    <form action="javascript:">
      RSS : 
      <select id="rssUrl">
        <option value="http://www.techno-science.net/include/news.xml">Techno-Science</option>
        <option value="http://www.latribune.fr/rss">La tribune</option>
      </select>
      <span id="message"></span>
    </form>
    <div id="rss">
      <div class="rssTitles">
        <table border="0" cellpadding="4" cellspacing="1" width="100%">
          <tr id="rssTitles">
            <th style="width: 14ex">
              Catgorie 
              <img src="down.gif" id="categorieDown"/>
              <img src="up.gif" id="categorieUp"/>
            </th>
            <th style="width: 13ex">
              Date 
              <img src="down.gif" id="dateDown"/>
              <img src="up.gif" id="dateUp"/>
            </th>
            <th id="sujet">
              Sujet
              <img src="down.gif" id="sujetDown"/>
              <img src="up.gif" id="sujetUp"/>
            </th>
          </tr>
        </table>
      </div>
      <div id="rssHeader"></div>
      <div id="rssItem">Cliquez sur un sujet pour 
      en afficher ici le rsum</div>
    </div>
    
    <script>
window.onload = function() {
  view = new XSLView("rssHeader", "message");
  
  view.sort = function(select, order) {
    if (view != null && view.xslDoc != null && view.xmlDoc != null) {
      var tri;
      if (view.xslDoc.getElementsByTagNameNS) {
        tri = view.xslDoc.getElementsByTagNameNS(
          "http://www.w3.org/1999/XSL/Transform", "sort")[0];
      }
      else {
        tri = view.xslDoc.getElementsByTagName("xsl:sort")[0];
      }
      tri.setAttribute("select", select);
      tri.setAttribute("order", order);
      view.display();
    }
  }
  view.onload = function() {
    document.getElementById("categorieUp").onclick = function() {
      view.sort("category", "ascending");
    }
    document.getElementById("categorieDown").onclick = function() {
      view.sort("category", "descending");
    }
    document.getElementById("dateUp").onclick = function() {
      view.sort("substring(pubDate, 6, 11)", "ascending");
    }
    document.getElementById("dateDown").onclick = function() {
      view.sort("substring(pubDate, 6, 11)", "descending");
    }
    document.getElementById("sujetUp").onclick = function() {
      view.sort("title", "ascending");
    }
    document.getElementById("sujetDown").onclick = function() {
      view.sort("title", "descending");
    }
    document.getElementById("rssHeader").onclick = function(event) {
      var source = (window.event) ? window.event.srcElement :
        event.target;
      if (source.nodeName == "TD" 
        && source.getElementsByTagName("DIV").length !=0) {
        document.getElementById("rssItem").innerHTML =
          source.getElementsByTagName("DIV")[0].innerHTML;
      }
    }
    view.display();
  }
  
  view.loadXSL("rss-sommaire.xsl");
  view.loadXML(document.getElementById("rssUrl").value);
  
  document.getElementById("rssUrl").onchange = function() {
    view.loadXML(document.getElementById("rssUrl").value);
  }
}

    </script>
  </body>
</html>