/** @class
 * Affiche dans la zone de id idElement le flux RSS 2.0 venant 
 * de <code>url</code>.<br/>
 * Les liens s'affichent dans la cible <code>target</code>
 * (par dfaut la fentre courante _self).<br/>
 *
 * Comprend des flux RSS 2.0. En utilise l'arborescence 
 * <code>channel > item > title, link, description</code> :
 * L'lment channel a n item, chaque item ayant
 * un title, un link et une description.
 * @requires util.js
 */
function RSSBox(url, idElement, maxNumber, target) {
  if (!window.XMLHttpRequest) {
    throw "Requiert XMLHttpRequest()";
  }
  /** URL du flux RSS */
  this.url = url;
  /** Titre du flux */
  this.title = "";
  /** Elment affichant le rsultat HTML */
  this.element = document.getElementById(idElement);
  /** Requte pour le flux RSS */
  this.request = null;
  /** Nombre maximal de nouvelles affiches (dfaut 10)*/
  this.maxNumber = maxNumber || 10;
  /** Nom de la fentre o renvoyer les liens (dfaut _self)*/
  this.target = target || "_self";
  this.init();
  this.load();
}

RSSBox.prototype = {
  /** URL de la page sur le serveur jouant le rle 
   * de proxy (dfaut <code>serveur/open-url.php?url=</code>).
   */
  proxyUrl: "serveur/open-url.php?url=",
  
  /** Initialisation */
  init: function() {
    // Par defaut, affiche sous forme de liens
    this.onload = this.display;
  },

  /** Emettre la requte pour rcuprer le flux RSS.<br/>
   * XMLHttpRequest ne permettant de rcuprer que des url situes
   * sur le mme serveur, pour des raisons de scurit,
   * cette mthode appelle la page <code>proxyUrl</code>
   * qui renvoie intgralement la page d'url passe en paramtre :
   * avec ses en-ttes et son corps (mais sans les fichiers lis : 
   * css, images, scripts etc dans le cas d'une page html)
   */
  load: function(time) {
    // Annuler la requete si elle est en cours
    if (this.request) {
      try {
        this.request.abort();
      }
      catch (exc) {}
    }
    this.request = new XMLHttpRequest();
    var rssUrl = this.proxyUrl + encodeURIComponent(this.url);
    if (time) {
      rssUrl += "&time="+now;
    }
    this.request.open("GET", rssUrl, true);
    var current = this;
    this.request.onreadystatechange = function() {
      if (current.request.readyState == 4) {
        if (current.request.status == 200) {
          current.onload();
        }
        else {
          current.element.innerHTML = 
            "Impossible de rcuprer <a href='"
            + current.url + "'>ce flux RSS</a> (http status : " 
            + current.request.status + ")";
        }
      }
    }
    this.element.innerHTML = "En chargement ...";
    this.request.send("");
  },
  
  /** Recharge le flux RSS */
  reload: function() {
    var now = (new Date()).getTime();
    this.load(now);
  },

  /** Afficher le flux RSS quand il est reu */
  display: function() {
    this._setTitle();
    this.element.innerHTML = "";
    var ele = this.request.responseXML.documentElement;
    ele = Element.getChildElements(ele, "channel")[0];
    var items = Element.getChildElements(ele, "item");
    var i, link, length;
    length = Math.min(items.length, this.maxNumber);
    for (i=0 ; i < length ; i++) {
      // Creer un lien par item
      link = document.createElement("a");
      // Avec l'url trouvee dans link
      ele = Element.getChildElements(items[i], "link")[0];
      link.setAttribute("href", Element.textContent(ele));
      link.setAttribute("target", this.target);
      // Le texte venant de title
      ele = Element.getChildElements(items[i], "title")[0];
      link.innerHTML = Element.textContent(ele);
      // Le lien en affichage block
      link.style.display = "block";
      this.element.appendChild(link);
    }
  },
  
  /** Recuperer le titre @private */
  _setTitle: function() {
    try {
      var node = this.request.responseXML.documentElement;
      node = node.getChildren("channel")[0];
      node = node.getChildren("title")[0];
      this.title = Element.textContent(node);
    }
    catch (exc) {}
  }
}

RSSBox.prototype.constructor = RSSBox;