if (!window.XMLHttpRequest) {
  XMLHttpRequest = function() {
    return new ActiveXObject("Microsoft.XMLHTTP");
  }
}

/** @class
 * @requires util.js (Log et harmonisation XMLHttp)
 */
function XSLView(idOutput, idMsg, xmlDoc, xslDoc) {
  this.idOutput = idOutput;
  this.output = document.getElementById(idOutput);
  this.xmlDoc = xmlDoc || null;
  this.xslDoc = xslDoc || null;
  this.xmlRequest = null;
  this.xslRequest = null;
  this.msg = (document.getElementById(idMsg)) ?
    document.getElementById(idMsg) : this.output;
}

XSLView.prototype = {
  proxy: "serveur/open-url.php?url=",

  loadXML: function(url) {
    this._load(url, "xmlDoc", this.xmlRequest);
  },

  loadXSL: function(url) {
    this._load(url, "xslDoc", this.xslRequest);
  },

  _load: function(url, targetName, request) { 
    if (!window.ActiveXObject && !window.XSLTProcessor) {
      this.output.innerHTML = "Cette page ncessite Internet " +
        "Explorer 6 et plus, ou Firefox 1.0 et plus";
      return;
    }
    if (request) {
      try {
        request.abort();
      }
      catch (exc) {}
    }
    if (/^http:/.test(url)) {
      url = this.proxy + encodeURIComponent(url);
    }
    try {
      var current = this;
      request = new XMLHttpRequest();
      request.open("GET", url, true);
      request.onreadystatechange = function() {
        if (request.readyState == 4) {
          if (request.status == 200) {
            current[targetName] = request.responseXML;
            if (current.xmlDoc != null && current.xslDoc != null) {
              current.onload();
            }
          }
          else {
            current.log("Erreur HTTP "+request.status + " sur " + url);
          }
        }
      }
      this.msg.innerHTML = "En chargement ...";
      request.send("");
    }
    catch (exc) {
      this.log(exc);
    }
  },

  log: function(msg) {
    this.output.innerHTML += msg + "<br/>";
  },

  onload: function() {
    this.display();
  },

  display: function() {
    this.msg.innerHTML = "";
    var output = document.getElementById(this.idOutput);
    try { // IE
      output.innerHTML = this.xmlDoc.transformNode(this.xslDoc);
    }
    catch (exc) {// Mozilla
      try {
        var xsltProcessor = new XSLTProcessor();
        xsltProcessor.importStylesheet(this.xslDoc);
        var fragment = 
          xsltProcessor.transformToFragment(this.xmlDoc, document);
        output.innerHTML = "";
        output.appendChild(fragment);

      }
      catch (exc) {
        this.log(exc);
      }
    }
  }
}
