<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" version="4.0" encoding="utf-8"/>
  <xsl:template match="/">
    <table border="0" cellpadding="4" cellspacing="1" width="100%">
      <tbody>
        <xsl:apply-templates select="/rss/channel[1]/item">
          <xsl:sort select="substring(pubDate, 6, 11)" 
            order="descending"/>
        </xsl:apply-templates>
      </tbody>
    </table>
  </xsl:template>
  
  <xsl:template match="item">
    <tr>
      <td style="width: 14ex">
        <xsl:value-of select="category"/>
      </td>
      <td style="width: 13ex">
        <xsl:value-of select="substring(pubDate, 6, 11)"/>
      </td>
      <td onmouseover="this.style.cursor='pointer';this.style.textDecoration='underline';"
        onmouseout="this.style.textDecoration='none'">
        <xsl:value-of select="title"/>
        <div style="display: none">
          <xsl:value-of select="substring(pubDate, 6, 11)"/> -
          <strong><xsl:value-of select="title"/></strong>
          <hr/>
          <xsl:value-of select="description"/>
          <br/>
          <a><xsl:attribute name="href">
              <xsl:value-of select="link"/>
            </xsl:attribute>Voir l'article en entier</a>
        </div>
      </td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
