<?php
// Cette page est la vue
// Les codes postaux devraient provenir du modele
$cps = array("06830", "06850", "46500");
?>
<html>
  <head>
    <title>Changement d'url avec dojo</title>
    <script>
    djConfig = { 
      isDebug: true,
      preventBackButtonFix: false
    };
    </script>
		<script type="text/javascript" src="dojo/dojo.js"></script>
  </head>
  <body>
    <h1>Communes par code postal</h1>
    <ul>
<?php
for ($i=0 ; $i<count($cps) ; $i++) {
  print "<li>
    <a  id='cp_$cps[$i]'
      href=\"javascript: getVillesParCp('$cps[$i]')\">$cps[$i]</a>
    </li>";
}
?>
    </ul>
  <div id="msg"></div>
  <script>
dojo.require("dojo.io");
dojo.require("dojo.undo.browser");

dojo.addOnLoad(function(){
  if (location.hash) {
    var codePostal = location.hash.substr(1);
    getVillesParCp(codePostal);
  }
  else {
    dojo.undo.browser.setInitialState({
      back: function() {
        dojo.byId("msg").innerHTML = "";
      },
      forward: function() {}
    });
  }
});

var ajaxCall;
function getVillesParCp(codePostal) {
  dojo.byId("msg").innerHTML = "En chargement...";
  var link = dojo.byId("cp_"+codePostal).focus();
  if (ajaxCall) {
    //dojo.undo.browser.forwardStack = [];
    ajaxCall.abort();
  }
  var params = {
    url: "serveur/get-villes-par-cp.php?output=json&cp=" 
      + codePostal,
    method: "get",
    mimetype: "text/json",
    changeUrl: codePostal,
    data: "",
    load: function(type, json, request) {
      var villes = dojo.lang.map(
        json.items, 
        function(ville) { return ville.text; }
      );
      this.data ="<ul><li>"  
        + villes.join("</li><li>") + "</li></ul>";
      ;
      dojo.byId("msg").innerHTML = this.data;
      ajaxCall = null;
    },
    error: function(type, error) {
      dojo.byId("msg").innerHTML = error.message;
    },
    back: function() {
      dojo.byId("msg").innerHTML = this.data;
      dojo.byId("cp_"+codePostal).focus();
    },
    forward: function() {
      dojo.byId("msg").innerHTML = this.data;
      dojo.byId("cp_"+codePostal).focus();
    }
  }
  ajaxCall = dojo.io.bind(params);
}
    </script>
  </body>
</html>