<?php
/** Renvoie une liste de noms de commune dont le code postal vaut
 * le parametre "cp", trie par ordre alphabetique croissant.
 * La liste est de la forme "no1=nom1;no2=nom2; ...;noN=nomN"
 */
// Delai pour realisme
sleep(1);
if (array_key_exists("cp", $_REQUEST)) {
  $tomorrow = 0;//60*60*24; // en nb de secondes
  header("Cache-Control: max-age=$tomorrow");
  if (!array_key_exists("output", $_REQUEST)
    || $_REQUEST["output"] == "xml") {
    print_xml();
  }
  else if ($_REQUEST["output"] == "json") {
    print_json();
  }
  else if ($_REQUEST["output"] == "text") {
    print_plain();
  }
  // ce else if inutile (juste la pour demontrer une
  // impossibilite cote IE)
  else if ($_REQUEST["output"] == "html") {
    print_html();
  }
  else {
    print_usage();
  }
}
else {
  print_usage();
}

function print_usage() {
  print "Usage : <ul>
    <li>$_SERVER[PHP_SELF]?cp=unCp (sortie XML)</li>
    <li>$_SERVER[PHP_SELF]?cp=unCp&output=text (sortie texte)</li>
    <li>$_SERVER[PHP_SELF]?cp=unCp&output=json (sortie JSON)</li>
  </ul>";
}

function print_plain() {
  header("Content-type: text/html; charset=UTF-8");
  $communes = get_communes($_REQUEST["cp"]);
  $result = array();
  foreach ($communes as $commune) {
    $result[] = "$commune[value]=$commune[text]";
  }
  $result = implode(";", $result);
  print mb_convert_encoding($result, "UTF-8", "CP1252");
}

function print_json() {
  include_once("JSON.php");
  $json = new Services_JSON();
  $communes = get_communes($_REQUEST["cp"]);
  // On ne peut pas utiliser foreach qui travaille par copie
  // et non par reference
  for($i=0 ; $i<count($communes) ; $i++) {
    $communes[$i]["text"] = 
      mb_convert_encoding($communes[$i]["text"], "UTF-8", "CP1252");
  }
  $result = array("cp" => $_REQUEST["cp"], "items" => $communes);
  header("Content-type: text/javascript");
  print $json->encode($result);
}

function print_xml() {
  header("Content-Type: text/xml; charset=UTF-8");
  print "<?xml version='1.0' encoding='UTF-8'?>";
  print "<communes cp='$_REQUEST[cp]'>\n";
  $communes = get_communes($_REQUEST["cp"]);
  foreach ($communes as $commune) {
    $text = mb_convert_encoding($commune["text"], "UTF-8", "CP1252");
    print "<item value='$commune[value]' text=\"$text\"/>\n";
  }
  print "</communes>";
}

// Attention : un client qui mettrait a jour le innerHTML
// d'un select par le resultat de cette fonction ne fonctionnerait
// pas dans IE
function print_html() {
  header("Content-Type: text/html; charset=windows-1252");
  $communes = get_communes($_REQUEST["cp"]);
  foreach ($communes as $commune) {
    print "<option value='$commune[value]'>$commune[text]</option>\n";
  }
}


function get_communes($cp) {
  // On se connecte a la base
  include_once("database.php");
  $connect = get_db_connection();
  // On recupere les enregistreents
  $sql = "
    SELECT commune.no_commune AS no_commune, nom_commune
    FROM commune INNER JOIN cp ON commune.no_commune = cp.no_commune
    WHERE cp.cp = '$cp'
    ORDER BY nom_commune ASC
  ";
  /* plus efficace mais base pas normalisee
    $sql = "
    SELECT no_commune, nom_commune
    FROM commune 
    WHERE cp LIKE '%$cp%'
    ORDER BY nom_commune ASC
    ";
  */
  $lignes = mysql_query($sql)
    or die("Requete \"$query\" invalide\n".mysql_error());
  // On cree le resultat
  $result = array();
  while($row = mysql_fetch_array($lignes)){
    $result[] = array(
      "value" => $row["no_commune"], 
      "text" => $row["nom_commune"]
    );
  }
  mysql_close();
  return $result;
}
?>