<?php
function print_products() {
  include_once("serveur/ProductStore.inc.php");
  $store = new ProductStore();
  $products = $store->products;
  foreach ($products as $product) {
    $name = utf8_decode($product["name"]);
    print "
    <tr>
      <td>$name</td>
      <td class='montant'>$product[price]</td>
      <td>
        <a href='javascript: panier.add($product[id])'>ajouter</a>
      </td>
    </tr>
    ";
  }
}
?>
<html>
  <head>
    <title>Gestion d'un panier en Ajax</title>
    <link rel="stylesheet" type="text/css" href="panier-vue.css"/>
    <script>
    djConfig = { 
      isDebug: true
    };
    </script>
		<script type="text/javascript" src="../06-toolkits/dojo/dojo.js"></script>
    <script language="JavaScript" type="text/javascript">
      dojo.require("dojo.widget.Toggler");
      dojo.require("dojo.widget.FloatingPane");
      dojo.require("dojo.widget.Dialog");
      // Il faut absolument utiliser dojo.addOnLoad plutot que
      // window.onload, qui ne fait pas ce qu'on attend
      dojo.addOnLoad(function() {
        panier = new Cart();
        panierMessage = new CartMessageView(panier, "zoneMessage");
        panierIcone = new CartIconView(panier,
          "panierVueIcone", "cart.gif");
        panierSoumission = new CartSubmitView(panier, 
          "panierVueSoumission");
        panierTableau = new CartTableView(panier, 
          "panierVueTableau");
        panier.get();
        dojo.byId("panierConfirmer").onclick = function() {
          panier.validate();
        }
        dojo.byId("panierAnnuler").onclick = function() {
          if (panier.requests.length > 0) {
            panier.cancelRequest();
            panier.get();
          }
          dojo.widget.byId("panierVueSoumission").hide();
        }
      });
      function afficherVueValider() {
        dojo.widget.byId("panierVueSoumission").show();
      }
    </script>
    <script src="json.js"></script>
    <script type="text/javascript" src="Cart.js"></script>        
  </head>
  <body>
    <div id="zoneMessage">Barre de messages</div>

    <table width="100%" height="100%" border="0" cellpadding="4">
      <tr style="vertical-align: top">
        <td class="menuSite">
          <p>Accueil</p>
          <p>Recherche</p>
          <p>Promotions</p>
          <p>etc.</p>
          <div id="panierVueIcone" dojoType="Toggler" 
            targetId="divPanierVueTableau"></div>
        </td>
        <td>
          <h1>Produits trouvs</h1>
          <table border="1" cellspacing="0" cellpadding="4">
            <tr>
              <th>Produit</th>
              <th>Prix ()</th>
              <th>Panier</th>
            </tr>
            <?= print_products(); ?>
          </table>
        </td>
      </tr>
    </table>

    <div dojoType="Dialog" id="panierVueSoumission" 
      bgColor="#DDDDDD" bgOpacity="0.5">
      <p>Voulez-vous valider votre panier ?</p>
      <form action="javascript:;">
        <input type="button" value="Confirmer" id="panierConfirmer"/>
        <input type="button" value="Annuler" id="panierAnnuler"/>
      </form>
    </div>
    
   
    <div title="Votre panier" id="divPanierVueTableau" 
      style="display: none"
      dojoType="FloatingPane" isModal="true"
      hasShadow="false"
      resizable="true"
      displayMinimizeAction="true"
      displayMaximizeAction="true"
      displayCloseAction="false">
      <table id="panierVueTableau" border="1"
        cellpadding="4" cellspacing="0">
        <caption style="white-space: nowrap">Votre panier</caption>
        <tr>
          <th>Produit</th>
          <th>Quantit</th>
          <th>Prix<br/>unitaire</th>
          <th>Total</th>
        </tr>
        <tr>
          <td></td>
          <td>
            <form action="javascript:;"
              onsubmit="panier.update(this.idProduct.value, this.quantity.value);">
              <input type="hidden" name="idProduct"/>
              <input type="text" name="quantity" size="2" class="quantite"/>
              <button type="submit" class="icon">
                <img src="pencil.gif"/>
              </button>
              <button class="icon" type="button"
                onclick="panier.remove(this.form.idProduct.value)">
                <img src="cancel.gif"/>
              </button>
            </form>
          </td>
          <td class="montant"></td>
          <td class="montant"></td>
        </tr>
        <tr>
          <td colspan="4" style="text-align: center">
            <button onclick="afficherVueValider()">
            Valider le panier
            </button>
          </td>
        </tr>
      </table>
    </div>
    

    

  </body>
</html>