if (!window.XMLHttpRequest && window.ActiveXObject) {
  try {
    // Tester si les ActiveX sont autorises
    new ActiveXObject("Microsoft.XMLHTTP");
    // Definir le constructeur
    window.XMLHttpRequest = function() {
      var request;
      try {
        request = new ActiveXObject("Microsoft.XMLHTTP");
      }
      catch(exc) {
        request = new ActiveXObject('Msxml2.XMLHTTP');
      }
      return request;
    }
  }
  catch (exc) {}
}

Array.prototype.remove = function(item) {
  var i;
  for (i=0 ; i<this.length && this[i] != item ; i++);
  if (i < this.length) {
    this.splice(i, 1);
  }
}

function Cart() {
  /** Information sur le panier  */
  this.message = "";
  /** Achats du panier : tableau de tableaux associatifs 
   * id, name, price, quantity */
  this.products = new Array();
  /** Vues du panier. Chacune doit implmenter la mthode update,
   * qui met  jour son affichage. */
  this.views = new Array();
  /** Appels XMLHttpRequest en cours */
  this.requests = new Array();
}

Cart.prototype = {
  /** Montant total du panier */
  getTotal: function() {
    var result = 0;
    for (var i=0 ; i<this.products.length ; i++) {
      var product = this.products[i];
      result += product.price * product.quantity;
    }
    return result;
  },
  
  /** Lance une requte HTTP pour lire ou modifier le panier */
  execute: function(method, url, body) {
    var request = new XMLHttpRequest();
    request.open(method, url, true);
    if (method == "POST") {
		request.setRequestHeader("Content-type", 
      "application/x-www-form-urlencoded");
    }
    this.requests.push(request);
    var cart = this;
    request.onreadystatechange = function() {
      try {
        if (request.readyState == 4 
            && request.status == 200) {
          cart.requests.remove(request);
          var result = request.responseText.parseJSON();
          if ("error" in result) {
            cart.message = decodeURIComponent(result.error);
          }
          else {
            cart.products = result.products;
            cart.message = result.message || "";
          }
          cart.onload();
          cart.updateViews();
        }
      }
      catch (exc) {}
    }
    this.message = "En chargement ...";
    this.updateViews();
    request.send(body);
  },
  
  /** Rcupre le panier */
  get: function() {
    this.execute("GET", "serveur/panier.php?action=display", "");
  },

  /** Ajoute un lment dans le panier. Si l'lment y est dj,
   * augmente sa quantit */
  add: function(productId) {
    this.execute("POST", "serveur/panier.php", 
        "id=" + productId + "&action=add");
  },
  
  /** Enlve l'lment de id <code>productId</code> */
  remove: function(productId) {
    this.execute("POST", "serveur/panier.php",
      "id=" + productId + "&action=remove");
  },
  
  /** Modifie la quantite du produit de id <code>productId</code> */
  update: function(productId, newQuantity) {
    this.execute("POST", "serveur/panier.php", "id=" + productId + 
      "&quantity=" + newQuantity + "&action=update");
  },
  
  /** Soumettre le panier */
  validate: function() {
    this.execute("POST", "serveur/panier.php", "action=validate");
  },
  
  /** Annuler la dernire requte */
  cancelRequest: function() {
    if (this.requests.length > 0) {
      try {
        this.requests[this.requests.length-1].abort();
        this.requests.splice(this.requests.length-1, 1);
      }
      catch (exc) {}
    }
    this.message = "Requte annule";
    this.updateViews();
  },
  
  /** Action  l'arrive de la rponse de la dernire requte.
   * <br/>Par dfaut, ne fait rien. */
  onload: function() {},

  /** Met  jour les vues du panier */
  updateViews: function() {
    for (var i=0 ; i<this.views.length ; i++) {
      this.views[i].update();
    }
  }
}

/** Une vue du panier */
function CartView(cart, viewId) {
  /** Panier  afficher */
  this.cart = cart;
  /** Element HTML affichant le panier */
  this.element = document.getElementById(viewId);
  // Enregistrer la vue dans le panier
  this.cart.views.push(this);
}
CartView.prototype.update = function() {
  if (this.cart.requests.length > 0) {
    this.element.style.background = "#FDFFD4";
  }
  else {
    this.element.style.background = "";
  }
}

/** Vue du panier sous forme de message */
function CartMessageView(cart, viewId) {
  CartView.call(this, cart, viewId);
}
CartMessageView.prototype.update = function() {
  this.element.innerHTML = this.cart.message || "&nbsp;";
}

/** Vue du panier sous forme d'icne */
function CartIconView(cart, viewId, iconUrl) {
  CartView.call(this, cart, viewId);
  /** URL de l'icne reprsentant le panier */
  this.iconUrl = iconUrl;
}
CartIconView.prototype.update = function() {
  var nb = this.cart.products.length;
  var texte = (nb == 0) ? "(vide)" :
    this.cart.getTotal() + " <br/>(" + nb + " lignes)" ;
  this.element.innerHTML = '<img src="' + this.iconUrl +
    '" alt="Panier"/> ' + texte;
  CartView.prototype.update.call(this);
}


function CartSubmitView(cart, viewId) {
  CartView.call(this, cart, viewId);
}
CartSubmitView.prototype.update = function() {
  if (this.cart.products.length == 0) {
    dojo.widget.byId(this.element.id).hide();
  }
  CartView.prototype.update.call(this);
}


/** Vue du panier sous forme d'un tableau HTML */
function CartTableView(cart, viewId) {
  CartView.call(this, cart, viewId);
  /** Modle de ligne de la vue */
  this.template = this.element.rows[1].cloneNode(true);
  /** Bouton pour soumettre le formulaire */
  this.submitRow = this.element.rows[2].cloneNode(true);
}
CartTableView.prototype.update = function() {
  this.element.style.display = "";
  if (this.cart.products.length == 0) {
    this.element.tBodies[0].style.display = "none";
    this.element.caption.innerHTML = this.cart.message 
      || "Votre panier est vide";
  }
  else {
    this.element.tBodies[0].style.display = "";
    this.element.caption.innerHTML = "Votre panier (" + 
      this.cart.getTotal() + " )";
    // Supprimer toutes les lignes sauf les titres
    while (this.element.rows.length > 1) {
      this.element.tBodies[0].deleteRow(1);
    }
    for (var i=0 ; i<this.cart.products.length ; i++) {
      var row = this.template.cloneNode(true);
      this.element.tBodies[0].appendChild(row);
      var product = this.cart.products[i];
      row.cells[0].innerHTML = product.name;
      var form = row.cells[1].getElementsByTagName("form")[0];
      form.idProduct.value = product.id;
      form.quantity.value = product.quantity;
      row.cells[2].innerHTML = product.price;
      row.cells[3].innerHTML = product.price * product.quantity;
    }
    if (this.cart.requests.length == 0) {
      row = this.submitRow.cloneNode(true);
      this.element.tBodies[0].appendChild(row);
    }
  }
  CartView.prototype.update.call(this);
}
