<?php
/** Modele */
include_once("ProductStore.inc.php");

class Cart {
  /** Erreur produite lors de la derniere action (string)*/
  var $error;
  /** Message produit par la derniere action */
  var $message;
  
  function Cart() {
    if (!isset($_SESSION)) {
      session_start();
    }
    if (!array_key_exists("cart", $_SESSION)) {
      $_SESSION["cart"] = array();
    }
    $this->error = "";
    $this->message = "";
  }
  
  function add($id) {
    $this->error = "";
    // Chercher le produit dans le panier
    for ($i=0 ; $i<count($_SESSION["cart"]) 
      && $_SESSION["cart"][$i]["id"] != $id ; $i++);
    // S'il y est, incrementer sa quantite
    if ($i < count($_SESSION["cart"])) {
      $_SESSION["cart"][$i]["quantity"]++;
    }
    // Sinon, le rajouter
    else {
      // Recuperer le produit (id, name, price)
      $products = new ProductStore();
      $product = $products->get($id);
      if ($product != null) {
        $product["quantity"] = 1;
        $_SESSION["cart"][] = $product;
      }
      else {
        $this->error = "Produit de id $id inconnu";
      }
    }
  }
  
  function update($id, $quantity) {
    $this->error = "";
    if (ctype_digit($quantity) && $quantity >= 0) {
      // Chercher le produit dans le panier
      for ($i=0 ; $i<count($_SESSION["cart"]) 
        && $_SESSION["cart"][$i]["id"] != $id ; $i++);
      // S'il y est, mettre a jour
      if ($i < count($_SESSION["cart"])) {
        if ($quantity != 0) {
          $_SESSION["cart"][$i]["quantity"] = $quantity;
        }
        else {
          unset($_SESSION["cart"][$i]);
        }  
      }
      else {
        $this->error = 
          "Le produit de id $id n'est pas dans le panier";
      }
    }
    else {
      $this->error = 
        "La quantit doit tre un nombre positif ou nul";
    }
  }
  
  function remove($id) {
    $this->error = "";
    // Chercher le produit dans le panier
    for ($i=0 ; $i<count($_SESSION["cart"]) 
      && $_SESSION["cart"][$i]["id"] != $id ; $i++);
    // S'il y est, l'enlever
    if ($i < count($_SESSION["cart"])) {
      array_splice($_SESSION["cart"],$i, 1);
    }
    else {
      $this->error =
          "Le produit de id $id n'est pas dans le panier";
    }
  }
  
  function validate() {
    $this->error = "";
    // Creer la commande correspondant au panier
    // Si erreur, la positionner dans $this->error
    // Recuperer le n de commande dans $noCommande
    $noCommande = "123"; // ecrit en dur pour l'instant
    if ($this->error == "") {
      $_SESSION["cart"] = array();
      $this->message = 
        "Commande enregistre sous le n $noCommande";
    }
  }
}
?>