import java.io.*;
import java.net.*;

public class ServeurMeteoXML {

	public static void main (String[] args) throws IOException {
		ServerSocket serversocket = new ServerSocket(8080);
		System.out.println("Serveur demarre : " + serversocket);
		String STOP = "<commande valeur=\"stop\" />";
		String GO = "<commande valeur=\"go\" />";
		boolean init = false;
		boolean clientConnect = false;
		try {
			Socket socket = serversocket.accept();
			System.out.println("Connexion entrante : " + socket);
			try {
				BufferedReader entre = new BufferedReader(new InputStreamReader(socket.getInputStream()));
				Writer sortie = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
			
				int caractre = 1;
				while(true) {
					StringBuffer sb = new StringBuffer();
					while(true) {
						caractre = entre.read();
						if (caractre == 0) {
							break;
						}
						sb.append((char)caractre);
					}
					String message = sb.toString();
					// Ici, traitement XML du message et slection
					// d'une rponse approprie
					if (message != null && message.equals(STOP)) {
						System.out.println("Deconnexion en cours...");
						break;
					}
					if (message != null && message.equals(GO)) {
						init = true;
					}
					System.out.println("Message recu : " + message);
					if (init) {
						message = "<donnees_meteo temperature='" + (Math.floor((Math.random() * 61) - 20)) + "' pression='" + (Math.floor((Math.random() * 51) + 975)) + "'/>";
						sortie.write(message, 0, message.length());
						sortie.write(0);
						sortie.flush();
						System.out.println(message);
					}
				}
			}
			catch (IOException ioe) {
				System.out.println(ioe);
				System.out.println("Erreur d'entree/sortie.");
			}
			finally {
				socket.close();
				System.out.print("Deconnexion...");
			}
		}
		finally {
			serversocket.close();
			System.out.println("OK.");
		}
	}
}
