import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class Compteur extends HttpServlet {

	private Hashtable table = new Hashtable();
	
	public void doPost(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException {
		rponse.setContentType("application-x/www-urlformencoded");
		PrintWriter pw = rponse.getWriter();
		// remplacez /..../ par le chemin d'accs au rpertoire utilis
		String path = getServletConfig().getServletContext().getRealPath("/..../");
		String mode = requte.getParameter("mode");
		String compteur = requte.getParameter("page");
		String sessionID = null;
		String addr = requte.getRemoteAddr();
		long heure = System.currentTimeMillis();
		Long id = (Long)table.get(addr);
		if (id != null) {
			try {
				long ancienneHeure = id.longValue();
				if (heure - ancienneHeure < 1800000) {
					mode = "ro";
				}
			}
			catch (Exception e) {
			}
		}
		table.put(addr, new Long(heure));
		
		if (mode == null || mode.equals("")) {
			return;
		}
		
		if (compteur == null || compteur.equals("")) {
			return;
		}

		// Lecture de la valeur du compteur
		Properties properties = new Properties();
		int compte = 0;
		synchronized(this) {
			try {
				FileInputStream fichierCompteur = new FileInputStream(path + compteur);
				properties.load(fichierCompteur);
				fichierCompteur.close();
			}
			catch (IOException ioe) {
			}
			
			try {
				compte = Integer.parseInt(properties.getProperty("compte"));
			}
			catch (Exception e) {
			}
			if (mode.equals("rw")) {
				properties.setProperty("compte", "" + (++compte));
				try {
					FileOutputStream fichierCompteur = new FileOutputStream(path + compteur);
					properties.store(fichierCompteur, null);
					fichierCompteur.close();
				}
				catch (IOException ioe) {
				}
			}
		}
		
		pw.print("compteur=" + compte);
	}

	public void doGet(	HttpServletRequest requte,
						HttpServletResponse rponse)
						throws IOException, ServletException {
		doPost(requte, rponse);
	}
}